import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiNavigationBarButtonConfig } from "../generated/UiNavigationBarButtonConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiNavigationBar_ButtonClickedEvent, UiNavigationBar_FanoutClosedDueToClickOutsideFanoutEvent, UiNavigationBarCommandHandler, UiNavigationBarConfig, UiNavigationBarEventSource } from "../generated/UiNavigationBarConfig";
import { UiColorConfig } from "../generated/UiColorConfig";
import { UiComponent } from "./UiComponent";
export declare class UiNavigationBar extends AbstractUiComponent<UiNavigationBarConfig> implements UiNavigationBarCommandHandler, UiNavigationBarEventSource {
    readonly onButtonClicked: TeamAppsEvent<UiNavigationBar_ButtonClickedEvent>;
    readonly onFanoutClosedDueToClickOutsideFanout: TeamAppsEvent<UiNavigationBar_FanoutClosedDueToClickOutsideFanoutEvent>;
    private $bar;
    private $buttonsWrapper;
    private buttons;
    private buttonTemplateRenderer;
    private $fanOutContainerWrapper;
    private $fanOutContainer;
    private fanOutComponents;
    private currentFanOutComponent;
    private fanoutClickOutsideHandle;
    constructor(config: UiNavigationBarConfig, context: TeamAppsUiContext);
    setBackgroundColor(color: UiColorConfig): void;
    setBorderColor(color: UiColorConfig): void;
    getMainDomElement(): HTMLElement;
    setButtons(buttons: UiNavigationBarButtonConfig[]): void;
    private addButton;
    setButtonVisible(buttonId: string, visible: boolean): void;
    addFanOutComponent(fanOutComponent: UiComponent): void;
    removeFanOutComponent(fanOutComponent: UiComponent): void;
    showFanOutComponent(fanOutComponent: UiComponent): void;
    hideFanOutComponent(): void;
    onResize(): void;
    private findNearestParentWithHiddenVerticalOverflow;
    destroy(): void;
}
