import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiField } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiComboBoxCommandHandler, UiComboBoxConfig, UiComboBoxEventSource } from "../../generated/UiComboBoxConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
import { UiComboBoxTreeRecordConfig } from "../../generated/UiComboBoxTreeRecordConfig";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
export declare function isFreeTextEntry(o: UiComboBoxTreeRecordConfig): boolean;
export declare class UiComboBox extends UiField<UiComboBoxConfig, UiComboBoxTreeRecordConfig> implements UiComboBoxEventSource, UiComboBoxCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private trivialComboBox;
    private templateRenderers;
    private freeTextIdEntryCounter;
    protected initialize(config: UiComboBoxConfig, context: TeamAppsUiContext): void;
    protected initFocusHandling(): void;
    private renderRecord;
    isValidData(v: any): boolean;
    getMainInnerDomElement(): HTMLElement;
    protected displayCommittedValue(): void;
    getTransientValue(): any;
    protected convertValueForSendingToServer(value: UiComboBoxTreeRecordConfig): any;
    focus(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    replaceFreeTextEntry(freeText: string, record: UiComboBoxTreeRecordConfig): void;
    destroy(): void;
    getReadOnlyHtml(value: UiComboBoxTreeRecordConfig, availableWidth: number): string;
    getDefaultValue(): any;
    valuesChanged(v1: UiComboBoxTreeRecordConfig, v2: UiComboBoxTreeRecordConfig): boolean;
}
