import { GraphContext } from "./GraphContext";
import { AbstractUiGraph } from "./AbstractUiGraph";
import { UiIncidentGraphConfig } from "../../generated/UiIncidentGraphConfig";
import { UiIncidentGraphDataConfig } from "../../generated/UiIncidentGraphDataConfig";
export declare class UiIncidentGraph extends AbstractUiGraph<UiIncidentGraphConfig, UiIncidentGraphDataConfig> {
    private graphContext;
    private dataStore;
    private popperHandle;
    constructor(timeGraphId: string, config: UiIncidentGraphConfig, graphContext: GraphContext);
    getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    addData(zoomLevel: number, data: UiIncidentGraphDataConfig): void;
    resetData(): void;
    getYDataBounds(intervalX: [number, number]): [number, number];
    doRedraw(): void;
    destroy(): void;
}
