import { UiField } from "./UiField";
import { UiClientRecordConfig } from "../../generated/UiClientRecordConfig";
import { UiTemplateField_ClickedEvent, UiTemplateFieldCommandHandler, UiTemplateFieldConfig, UiTemplateFieldEventSource } from "../../generated/UiTemplateFieldConfig";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export declare class UiTemplateField extends UiField<UiTemplateFieldConfig, UiClientRecordConfig> implements UiTemplateFieldCommandHandler, UiTemplateFieldEventSource {
    readonly onClicked: TeamAppsEvent<UiTemplateField_ClickedEvent>;
    private $main;
    private templateRenderer;
    constructor(config: UiTemplateFieldConfig, context: TeamAppsUiContext);
    protected initialize(config: UiTemplateFieldConfig, context: TeamAppsUiContext): void;
    update(config: UiTemplateFieldConfig): void;
    getMainInnerDomElement(): HTMLElement;
    protected displayCommittedValue(): void;
    focus(): void;
    getTransientValue(): UiClientRecordConfig;
    isValidData(v: UiClientRecordConfig): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode, oldEditingMode?: UiFieldEditingMode): void;
    valuesChanged(v1: UiClientRecordConfig, v2: UiClientRecordConfig): boolean;
    getReadOnlyHtml(value: UiClientRecordConfig, availableWidth: number): string;
}
