import { UiToolbarButtonGroupConfig } from "../../../generated/UiToolbarButtonGroupConfig";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiToolbarButtonConfig } from "../../../generated/UiToolbarButtonConfig";
import { ButtonVisibilities, UiToolbar } from "./UiToolbar";
import { UiDropDownButtonClickInfoConfig } from "../../../generated/UiDropDownButtonClickInfoConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiComponent } from "../../UiComponent";
export declare class UiToolbarButtonGroup {
    private toolbar;
    private context;
    readonly onButtonClicked: TeamAppsEvent<{
        buttonId: string;
        dropDownButtonClickInfo: UiDropDownButtonClickInfoConfig;
    }>;
    private config;
    private visible;
    private $buttonGroupWrapper;
    private $buttonGroup;
    private buttons;
    private $separator;
    private buttonsShiftedToOverflowDropDown;
    constructor(buttonGroupConfig: UiToolbarButtonGroupConfig, toolbar: UiToolbar, context: TeamAppsUiContext);
    getId(): string;
    private get toolbarId();
    get position(): import("../../../generated/UiToolbarButtonGroupPosition").UiToolbarButtonGroupPosition;
    private createButton;
    setDropDownComponent(buttonId: string, component: UiComponent): void;
    setButtonVisible(buttonId: string, visible: boolean): void;
    addButton(buttonConfig: UiToolbarButtonConfig, neighborButtonId: string, beforeNeighbor: boolean): void;
    removeButton(buttonId: string): void;
    setVisible(visible: boolean): void;
    isVisible(): boolean;
    private updateVisibility;
    setButtonColors(buttonId: string, backgroundColor: string, hoverBackgroundColor: string): void;
    calculateButtonVisibilities(availableWidth: number): ButtonVisibilities;
    getMainDomElement(): HTMLElement;
    getButtonConfigs(): UiToolbarButtonConfig[];
    setButtonHasDropDown(buttonId: string, hasDropDown: boolean): void;
    getConfig(): UiToolbarButtonGroupConfig;
}
