import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiDefaultMultiProgressDisplayCommandHandler, UiDefaultMultiProgressDisplayConfig, UiDefaultMultiProgressDisplayEventSource } from "../generated/UiDefaultMultiProgressDisplayConfig";
import { UiMultiProgressDisplay_ClickedEvent, UiMultiProgressDisplayCommandHandler, UiMultiProgressDisplayConfig, UiMultiProgressDisplayEventSource } from "../generated/UiMultiProgressDisplayConfig";
export declare abstract class UiMultiProgressDisplay<C extends UiMultiProgressDisplayConfig = UiMultiProgressDisplayConfig> extends AbstractUiComponent<C> implements UiMultiProgressDisplayCommandHandler, UiMultiProgressDisplayEventSource {
    readonly onClicked: TeamAppsEvent<UiMultiProgressDisplay_ClickedEvent>;
    abstract update(config: C): void;
}
export declare class UiDefaultMultiProgressDisplay extends UiMultiProgressDisplay<UiDefaultMultiProgressDisplayConfig> implements UiDefaultMultiProgressDisplayCommandHandler, UiDefaultMultiProgressDisplayEventSource {
    private $main;
    private $spinner;
    private $runningCount;
    constructor(config: UiDefaultMultiProgressDisplayConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    update(config: UiDefaultMultiProgressDisplayConfig): void;
}
