import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiWindow } from "./UiWindow";
import { UiConfigurationConfig } from "../generated/UiConfigurationConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext, TeamAppsUiContextInternalApi } from "./TeamAppsUiContext";
import { UiRootPanel_GlobalKeyEventOccurredEvent, UiRootPanel_NavigationStateChangeEvent, UiRootPanelCommandHandler, UiRootPanelConfig, UiRootPanelEventSource } from "../generated/UiRootPanelConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiGenericErrorMessageOption } from "../generated/UiGenericErrorMessageOption";
import { UiComponent } from "./UiComponent";
import { UiPageTransition } from "../generated/UiPageTransition";
import { UiPopup } from "./UiPopup";
import { UiNotification } from "./UiNotification";
import { UiNotificationPosition } from "../generated/UiNotificationPosition";
import { UiEntranceAnimation } from "../generated/UiEntranceAnimation";
import { UiExitAnimation } from "../generated/UiExitAnimation";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare class UiRootPanel extends AbstractUiComponent<UiRootPanelConfig> implements UiRootPanelCommandHandler, UiRootPanelEventSource {
    static readonly onGlobalKeyEventOccurred: TeamAppsEvent<UiRootPanel_GlobalKeyEventOccurredEvent>;
    static readonly onNavigationStateChange: TeamAppsEvent<UiRootPanel_NavigationStateChangeEvent>;
    private static LOGGER;
    private static ALL_ROOT_PANELS_BY_ID;
    private static BACKGROUND_IMAGES_BY_ID;
    private static WINDOWS_BY_ID;
    private $root;
    private content;
    private $contentWrapper;
    private $backgroundTransitionStyle;
    private $backgroundStyle;
    private $imagePreloadDiv;
    private backgroundImage;
    private blurredBackgroundImage;
    private backgroundColor;
    constructor(config: UiRootPanelConfig, context: TeamAppsUiContext);
    static setGlobalKeyEventsEnabled(unmodified: boolean, modifiedWithAltKey: boolean, modifiedWithCtrlKey: boolean, modifiedWithMetaKey: boolean, includeRepeats: boolean, keyDown: boolean, keyUp: boolean): void;
    doGetMainElement(): HTMLElement;
    setContent(content: UiComponent, transition?: UiPageTransition | null, animationDuration?: number): void;
    static createComponent(config: UiComponentConfig, context: TeamAppsUiContextInternalApi): void;
    static destroyComponent(componentId: string, context: TeamAppsUiContextInternalApi): void;
    static refreshComponent(config: UiComponentConfig, context: TeamAppsUiContextInternalApi): void;
    static setConfig(config: UiConfigurationConfig, context: TeamAppsUiContext): void;
    static setSessionMessageWindows(expiredMessageWindow: UiWindow, errorMessageWindow: UiWindow, terminatedMessageWindow: UiWindow, context: TeamAppsUiContext): void;
    static setPageTitle(pageTitle: string): void;
    private static get ALL_ROOT_PANELS();
    static registerBackgroundImage(id: string, image: string, blurredImage: string): void;
    static setBackgroundImage(id: string, animationDuration: number): void;
    static setBackgroundColor(backgroundColor: string, animationDuration: number): void;
    private updateBackground;
    destroy(): void;
    static buildRootPanel(containerElementId: string, uiRootPanel: UiRootPanel, context?: TeamAppsUiContext): void;
    static setThemeClassName(theme: string): void;
    static showNotification(notification: UiNotification, position: UiNotificationPosition, entranceAnimation: UiEntranceAnimation, exitAnimation: UiExitAnimation, context: TeamAppsUiContext): void;
    static downloadFile(fileUrl: string, fileName: string): boolean;
    static registerTemplate(name: string, template: UiTemplateConfig, context: TeamAppsUiContext): void;
    static registerTemplates(templates: {
        [name: string]: UiTemplateConfig;
    }, context: TeamAppsUiContext): void;
    static addClientToken(token: string): void;
    static removeClientToken(token: string): void;
    static clearClientTokens(): void;
    private static loadClientTokens;
    static getClientTokens(): string[];
    private static saveClientTokens;
    static exitFullScreen(): void;
    static createGenericErrorMessageWindow(title: string, message: string, showErrorIcon: boolean, options: UiGenericErrorMessageOption[], context: TeamAppsUiContext): UiWindow;
    setOptimizedForTouch(optimizedForTouch: boolean): void;
    static showPopupAtCurrentMousePosition(popup: UiPopup): void;
    static showPopup(popup: UiPopup): void;
    static requestWakeLock(uuid: string): Promise<boolean>;
    static releaseWakeLock(uuid: string): Promise<void>;
    static goToUrl(url: string, blankPage: boolean): Promise<void>;
    static pushHistoryState(relativeUrl: string): Promise<void>;
    static navigateForward(steps: number): Promise<void>;
    static setFavicon(url: string): void;
    static setTitle(title: string): void;
}
