import { AbstractUiComponent } from "../AbstractUiComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { ScaleTime } from "d3-scale";
import { UiTimeGraph_IntervalSelectedEvent, UiTimeGraph_ZoomedEvent, UiTimeGraphCommandHandler, UiTimeGraphConfig, UiTimeGraphEventSource } from "../../generated/UiTimeGraphConfig";
import { UiLongIntervalConfig } from "../../generated/UiLongIntervalConfig";
import { UiLineChartMouseScrollZoomPanMode } from "../../generated/UiLineChartMouseScrollZoomPanMode";
import { UiTimeChartZoomLevelConfig } from "../../generated/UiTimeChartZoomLevelConfig";
import { UiGraphDataConfig } from "../../generated/UiGraphDataConfig";
import { UiGraphConfig } from "../../generated/UiGraphConfig";
import { AbstractUiGraph } from "./AbstractUiGraph";
import { GraphContext } from "./GraphContext";
export declare const yTickFormat: (n: number | {
    valueOf(): number;
}) => string;
export declare class UiTimeGraph extends AbstractUiComponent<UiTimeGraphConfig> implements UiTimeGraphCommandHandler, UiTimeGraphEventSource {
    readonly onIntervalSelected: TeamAppsEvent<UiTimeGraph_IntervalSelectedEvent>;
    readonly onZoomed: TeamAppsEvent<UiTimeGraph_ZoomedEvent>;
    static readonly LOGSCALE_MIN_Y = 0.5;
    static readonly DROP_SHADOW_ID = "drop-shadow";
    private mouseScrollZoomPanMode;
    private intervalX;
    private maxPixelsBetweenDataPoints;
    private graphById;
    private $main;
    private $svg;
    private $rootG;
    private $dropShadowFilter;
    private $clipPath;
    private scaleX;
    private dropShadowFilterId;
    private margin;
    private zoom;
    private xAxis;
    private $xAxis;
    private $horizontalPanRect;
    private brush;
    private $brush;
    private $graphClipContainer;
    private xSelection;
    private zoomLevels;
    private $yAxisContainer;
    private lastDrawableWidth;
    private eventsPopper;
    private graphContext;
    get drawableWidth(): number;
    private get drawableHeight();
    private get marginLeft();
    constructor(config: UiTimeGraphConfig, context: TeamAppsUiContext);
    zoomTo(intervalX: UiLongIntervalConfig): void;
    private createGraph;
    static createDataDisplay(timeGraphId: string, graphConfig: UiGraphConfig, dropShadowFilterId: string, graphContext: GraphContext): AbstractUiGraph<UiGraphConfig, UiGraphDataConfig>;
    getTransformedScaleX(): ScaleTime<number, number>;
    private redraw;
    private restrictDomainXToConfiguredInterval;
    getCurrentZoomLevel(): number;
    private getMillisecondsPerPixel;
    private getSortedZoomLevels;
    private handleBrushSelection;
    onResize(): void;
    private updateZoomExtents;
    private getAllSeries;
    addData(zoomLevel: number, data: {
        [graphId: string]: UiGraphDataConfig;
    }): void;
    resetAllData(intervalX: UiLongIntervalConfig, newZoomLevels: UiTimeChartZoomLevelConfig[]): void;
    resetGraphData(graphId: string): void;
    setIntervalX(intervalX: UiLongIntervalConfig): void;
    setMouseScrollZoomPanMode(mouseScrollZoomPanMode: UiLineChartMouseScrollZoomPanMode): void;
    private fireUiZoomEvent;
    setSelectedInterval(intervalX: UiLongIntervalConfig): void;
    setMaxPixelsBetweenDataPoints(maxPixelsBetweenDataPoints: number): void;
    doGetMainElement(): HTMLElement;
    private calculateMaxZoomFactor;
    setGraphs(graphs: UiGraphConfig[]): void;
    addOrUpdateGraph(graph: UiGraphConfig): void;
}
