import { UiField } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiLabel_ClickedEvent, UiLabelCommandHandler, UiLabelConfig, UiLabelEventSource } from "../../generated/UiLabelConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiComponent } from "../UiComponent";
export declare class UiLabel extends UiField<UiLabelConfig, string> implements UiLabelEventSource, UiLabelCommandHandler {
    readonly onClicked: TeamAppsEvent<UiLabel_ClickedEvent>;
    private $main;
    private $icon;
    private $caption;
    private targetComponent;
    private targetFieldVisibilityChangeHandler;
    protected initialize(config: UiLabelConfig, context: TeamAppsUiContext): void;
    setTargetComponent(targetField: UiComponent): void;
    isValidData(v: string): boolean;
    setCaption(caption: string): void;
    setIcon(icon: string): void;
    getMainInnerDomElement(): HTMLElement;
    focus(): void;
    getTransientValue(): string;
    getDefaultValue(): string;
    protected displayCommittedValue(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    valuesChanged(v1: string, v2: string): boolean;
}
