import { UiPanelHeaderFieldConfig } from "../generated/UiPanelHeaderFieldConfig";
import { UiToolbar } from "./tool-container/toolbar/UiToolbar";
import { UiToolButton } from "./micro-components/UiToolButton";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiPanel_WindowButtonClickedEvent, UiPanelCommandHandler, UiPanelConfig, UiPanelEventSource } from "../generated/UiPanelConfig";
import { UiWindowButtonType } from "../generated/UiWindowButtonType";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiComponent } from "./UiComponent";
export declare class UiPanel extends AbstractUiComponent<UiPanelConfig> implements UiPanelCommandHandler, UiPanelEventSource {
    readonly onWindowButtonClicked: TeamAppsEvent<UiPanel_WindowButtonClickedEvent>;
    private readonly defaultToolButtons;
    private readonly orderedDefaultToolButtonTypes;
    private $panel;
    private $heading;
    private $toolbarContainer;
    private $bodyContainer;
    private $leftComponentWrapper;
    private $headingSpacer;
    private $rightComponentWrapper;
    private $buttonContainer;
    private $windowButtonContainer;
    private $icon;
    private $title;
    private contentComponent;
    private leftHeaderField;
    private rightHeaderField;
    private leftComponentFirstMinimized;
    private alwaysShowHeaderFieldIcons;
    private toolbar;
    private icon;
    private title;
    private titleNaturalWidth;
    private toolButtons;
    private windowButtons;
    private dropDown;
    private restoreFunction;
    constructor(config: UiPanelConfig, context: TeamAppsUiContext);
    setMaximized(maximized: boolean): void;
    maximize(): void;
    restore(): void;
    setDraggable(draggable: boolean): void;
    setToolButtons(toolButtons: UiToolButton[]): void;
    setWindowButtons(buttonTypes: UiWindowButtonType[]): void;
    addWindowButton(toolButtonType: UiWindowButtonType): void;
    removeWindowButton(uiToolButton: UiWindowButtonType): void;
    getWindowButton(buttonType: UiWindowButtonType): UiToolButton;
    getMainDomElement(): HTMLElement;
    setContent(content: UiComponent): void;
    private calculateFieldWrapperSizes;
    private readonly headerFields;
    private setMinimizedFields;
    setLeftHeaderField(headerFieldConfig: UiPanelHeaderFieldConfig): void;
    setRightHeaderField(headerFieldConfig: UiPanelHeaderFieldConfig): void;
    private setHeaderField;
    setIcon(icon: string): void;
    setTitle(title: string): void;
    private recalculateTitleNaturalWidth;
    setToolbar(toolbar: UiToolbar): void;
    setStretchContent(stretch: boolean): void;
    private updateToolbarVisibility;
    onResize(): void;
    private relayoutHeader;
    private numberOfVisibleHeaderFields;
    destroy(): void;
    static isDraggablePanelHeadingElement(target: HTMLElement): boolean;
}
