import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiImageCropper_SelectionChangedEvent, UiImageCropperCommandHandler, UiImageCropperConfig, UiImageCropperEventSource } from "../generated/UiImageCropperConfig";
import { UiImageCropperSelectionConfig } from "../generated/UiImageCropperSelectionConfig";
import { UiImageCropperSelectionMode } from "../generated/UiImageCropperSelectionMode";
export declare class UiImageCropper extends AbstractUiComponent<UiImageCropperConfig> implements UiImageCropperCommandHandler, UiImageCropperEventSource {
    readonly onSelectionChanged: TeamAppsEvent<UiImageCropper_SelectionChangedEvent>;
    private $element;
    private $selectionFrame;
    private htmlImageElement;
    private selection;
    private imageNaturalWidth;
    private imageNaturalHeight;
    constructor(config: UiImageCropperConfig, context: TeamAppsUiContext);
    private resetSelectionFrame;
    private handleDragEnd;
    private getSelectionFrameOffsetRect;
    private boundSelection;
    private calculateCoordinateCorrectionFactor;
    setImageUrl(url: string): void;
    setAspectRatio(aspectRatio: number): void;
    setSelection(selection: UiImageCropperSelectionConfig): void;
    setSelectionMode(selectionMode: UiImageCropperSelectionMode): void;
    onResize(): void;
    private updateCroppingFramePosition;
    private frameRectToSelection;
    private selectionToFrameRect;
    doGetMainElement(): HTMLElement;
}
