import { DebounceMode } from "./debounce";
export declare type TeamAppsEventListener<EO> = (eventObject?: EO) => void;
export interface EventSubscription {
    unsubscribe(): void;
}
/**
 * @param EO the event object type
 */
export declare class TeamAppsEvent<EO> {
    private listeners;
    private previousEventObject;
    fire: (eventObject: EO) => void;
    constructor(options?: {
        throttlingMode: "throttle" | "debounce";
        delay: number;
        debounceMode?: DebounceMode;
    });
    addListener(fn: TeamAppsEventListener<EO>, allowDuplicates?: boolean): EventSubscription;
    removeListener(fn: TeamAppsEventListener<EO>): void;
    private _fire;
    fireIfChanged(eventObject: EO): void;
    resetChangeValue(): void;
    getListeners(): TeamAppsEventListener<EO>[];
}
