import { UiField } from "./UiField";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiRichTextEditor_ImageUploadFailedEvent, UiRichTextEditor_ImageUploadStartedEvent, UiRichTextEditor_ImageUploadSuccessfulEvent, UiRichTextEditor_ImageUploadTooLargeEvent, UiRichTextEditorCommandHandler, UiRichTextEditorConfig, UiRichTextEditorEventSource } from "../../generated/UiRichTextEditorConfig";
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/plugins/lists';
import 'tinymce/plugins/table';
import 'tinymce/plugins/image';
import 'tinymce/plugins/imagetools';
import 'tinymce/plugins/link';
import 'tinymce/plugins/autolink';
import 'tinymce/plugins/contextmenu';
import 'tinymce/plugins/searchreplace';
import 'tinymce/plugins/spellchecker';
import 'tinymce/plugins/textcolor';
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiToolbarVisibilityMode } from "../../generated/UiToolbarVisibilityMode";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
export declare class UiRichTextEditor extends UiField<UiRichTextEditorConfig, string> implements UiRichTextEditorEventSource, UiRichTextEditorCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    readonly onImageUploadFailed: TeamAppsEvent<UiRichTextEditor_ImageUploadFailedEvent>;
    readonly onImageUploadStarted: TeamAppsEvent<UiRichTextEditor_ImageUploadStartedEvent>;
    readonly onImageUploadSuccessful: TeamAppsEvent<UiRichTextEditor_ImageUploadSuccessfulEvent>;
    readonly onImageUploadTooLarge: TeamAppsEvent<UiRichTextEditor_ImageUploadTooLargeEvent>;
    private static readonly TRANSLATION_FILES;
    private $main;
    private $toolbarContainer;
    private editor;
    private mceReadyExecutor;
    private uuid;
    private imageUploadSuccessCallbacksByUuid;
    private $fileField;
    private buttonGroupWidths;
    private _hasFocus;
    private maxImageFileSizeInBytes;
    private uploadUrl;
    private runningImageUploadsCount;
    private $spinnerWrapper;
    private destroying;
    protected initialize(config: UiRichTextEditorConfig, context: TeamAppsUiContext): void;
    private initTinyMce;
    protected initFocusHandling(): void;
    isValidData(v: string): boolean;
    private fireTextInputEvent;
    private updateSpinnerVisibility;
    setUploadedImageUrl(fileUuid: string, url: string): void;
    getMainInnerDomElement(): HTMLElement;
    protected displayCommittedValue(): void;
    focus(): void;
    destroy(): void;
    getTransientValue(): string;
    onResize(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode, oldEditingMode: UiFieldEditingMode): void;
    private updateToolbarVisiblity;
    private rerenderToolbar;
    private toolbarShouldBeShown;
    getDefaultValue(): string;
    setToolbarVisibilityMode(toolbarVisibilityMode: UiToolbarVisibilityMode): void;
    setMaxImageFileSizeInBytes(maxImageFileSizeInBytes: number): void;
    setUploadUrl(uploadUrl: string): void;
    getReadOnlyHtml(value: string, availableWidth: number): string;
    valuesChanged(v1: string, v2: string): boolean;
    private mayFireChangeEvents;
    setMinHeight(minHeight: number): void;
    setMaxHeight(maxHeight: number): void;
    append(s: string, scrollToBottom: boolean): void;
}
