import { UiField } from "../UiField";
import { UiFileFieldDisplayType } from "../../../generated/UiFileFieldDisplayType";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiFileField_FileItemClickedEvent, UiFileField_FileItemRemoveButtonClickedEvent, UiFileField_UploadCanceledEvent, UiFileField_UploadFailedEvent, UiFileField_UploadStartedEvent, UiFileField_UploadSuccessfulEvent, UiFileField_UploadTooLargeEvent, UiFileFieldCommandHandler, UiFileFieldConfig, UiFileFieldEventSource } from "../../../generated/UiFileFieldConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiTemplateConfig } from "../../../generated/UiTemplateConfig";
import { UiIdentifiableClientRecordConfig } from "../../../generated/UiIdentifiableClientRecordConfig";
export declare class UiFileField extends UiField<UiFileFieldConfig, UiIdentifiableClientRecordConfig[]> implements UiFileFieldEventSource, UiFileFieldCommandHandler {
    readonly onFileItemClicked: TeamAppsEvent<UiFileField_FileItemClickedEvent>;
    readonly onFileItemRemoveButtonClicked: TeamAppsEvent<UiFileField_FileItemRemoveButtonClickedEvent>;
    readonly onUploadCanceled: TeamAppsEvent<UiFileField_UploadCanceledEvent>;
    readonly onUploadFailed: TeamAppsEvent<UiFileField_UploadFailedEvent>;
    readonly onUploadStarted: TeamAppsEvent<UiFileField_UploadStartedEvent>;
    readonly onUploadSuccessful: TeamAppsEvent<UiFileField_UploadSuccessfulEvent>;
    readonly onUploadTooLarge: TeamAppsEvent<UiFileField_UploadTooLargeEvent>;
    private $wrapper;
    private $uploadButton;
    private $fileInput;
    private $uploadButtonTemplate;
    private fileItems;
    private itemRenderer;
    private displayType;
    private maxFiles;
    private maxBytesPerFile;
    private uploadButtonData;
    private uploadButtonTemplate;
    private uploadUrl;
    private $fileList;
    protected initialize(config: UiFileFieldConfig, context: TeamAppsUiContext): void;
    isValidData(v: any[]): boolean;
    setItemTemplate(itemTemplate: UiTemplateConfig): void;
    setDisplayType(displayType: UiFileFieldDisplayType): void;
    setMaxFiles(maxFiles: number): void;
    setAcceptedFileTypes(acceptedFileTypes: string[]): void;
    setMaxBytesPerFile(maxBytesPerFile: number): void;
    setShowEntriesAsButtonsOnHover(showEntriesAsButtonsOnHover: boolean): void;
    setUploadButtonData(uploadButtonData: any): void;
    setUploadButtonTemplate(uploadButtonTemplate: UiTemplateConfig): void;
    setUploadUrl(uploadUrl: string): void;
    private handleFiles;
    private get numberOfNonErrorFileItems();
    private get numberOfUploadingFileItems();
    private resetFileInput;
    private updateVisibilities;
    getMainInnerDomElement(): HTMLElement;
    focus(): void;
    protected displayCommittedValue(): void;
    replaceFileItem(uuid: string, data: UiIdentifiableClientRecordConfig): void;
    protected convertValueForSendingToServer(clientRecords: UiIdentifiableClientRecordConfig[]): any;
    private removeFileItem;
    private createFileItem;
    private removeItem;
    getTransientValue(): UiIdentifiableClientRecordConfig[];
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: UiIdentifiableClientRecordConfig[], availableWidth: number): string;
    getDefaultValue(): UiIdentifiableClientRecordConfig[];
    valuesChanged(v1: UiIdentifiableClientRecordConfig[], c2: UiIdentifiableClientRecordConfig[]): boolean;
    cancelAllUploads(): void;
    cancelUpload(uuid: string): void;
}
