export declare function throttledMethod(delay: number): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
/**
 *  Returns a function, whom's execution is limited with a certain delay.
 *  When the returned function gets called multiple times within a delay cycle, only the last invocation will be executed.
 *
 *  @see debounce
 */
export declare function throttle(func: (...args: any[]) => any, delay: number): ((...args: any[]) => void);
