import { TeamAppsUiContext } from "./TeamAppsUiContext";
import * as log from "loglevel";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { DeferredExecutor } from "./util/DeferredExecutor";
import { UiComponent } from "./UiComponent";
export declare abstract class AbstractUiComponent<C extends UiComponentConfig = UiComponentConfig> implements UiComponent<C> {
    protected _config: C;
    protected _context: TeamAppsUiContext;
    protected readonly logger: log.Logger;
    readonly onVisibilityChanged: TeamAppsEvent<boolean>;
    readonly deFactoVisibilityChanged: TeamAppsEvent<boolean>;
    readonly onResized: TeamAppsEvent<{
        width: number;
        height: number;
    }>;
    private width;
    private height;
    private visible;
    displayedDeferredExecutor: DeferredExecutor;
    constructor(_config: C, _context: TeamAppsUiContext);
    getId(): string;
    getTeamAppsType(): string;
    protected reLayout(width: number, height: number): void;
    /**
     * This method gets called whenever the available size for this component changes.
     */
    onResize(): void;
    /**
     * This method is called when the component gets destroyed.
     * It should be used to release any resources the component holds. This can be:
     *   - additional DOM elements that are not children of the component's main DOM element, e.g. attached to the document's body.
     *   - other resources that are not released just by removing the component's main DOM element
     */
    destroy(): void;
    private firstTimeGetMainElementCalled;
    /**
     * @return The main DOM element of this component.
     */
    getMainElement(): HTMLElement;
    protected abstract doGetMainElement(): HTMLElement;
    getWidth(): number;
    getHeight(): number;
    isVisible(): boolean;
    setVisible(visible?: boolean, fireEvent?: boolean): void;
    setStyle(selector: string, style: {
        [property: string]: string;
    }): void;
    setClassNames(selector: string, classNames: {
        [className: string]: boolean;
    }): void;
    setAttributes(selector: string, attributes: {
        [property: string]: string;
    }): void;
    private getElementForSelector;
}
