import { UiToolbar } from "./tool-container/toolbar/UiToolbar";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiTabConfig } from "../generated/UiTabConfig";
import { Emptyable } from "./util/Emptyable";
import { UiToolButton } from "./micro-components/UiToolButton";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiTabPanel_TabClosedEvent, UiTabPanel_TabNeedsRefreshEvent, UiTabPanel_TabSelectedEvent, UiTabPanel_WindowButtonClickedEvent, UiTabPanelCommandHandler, UiTabPanelConfig, UiTabPanelEventSource } from "../generated/UiTabPanelConfig";
import { UiTabPanelTabStyle } from "../generated/UiTabPanelTabStyle";
import { UiWindowButtonType } from "../generated/UiWindowButtonType";
import { UiComponent } from "./UiComponent";
export declare class UiTabPanel extends AbstractUiComponent<UiTabPanelConfig> implements UiTabPanelCommandHandler, UiTabPanelEventSource, Emptyable {
    readonly onTabSelected: TeamAppsEvent<UiTabPanel_TabSelectedEvent>;
    readonly onTabNeedsRefresh: TeamAppsEvent<UiTabPanel_TabNeedsRefreshEvent>;
    readonly onTabClosed: TeamAppsEvent<UiTabPanel_TabClosedEvent>;
    readonly onEmptyStateChanged: TeamAppsEvent<boolean>;
    readonly onWindowButtonClicked: TeamAppsEvent<UiTabPanel_WindowButtonClickedEvent>;
    private readonly defaultToolButtons;
    private readonly orderedDefaultToolButtonTypes;
    private $tabPanel;
    private $leftButtonsWrapper;
    private $rightButtonsWrapper;
    private $dropDownButton;
    private $dropDown;
    private $dropButtonContainerLeft;
    private $dropButtonContainerRight;
    private $toolsContainer;
    private $toolButtonContainer;
    private $windowButtonContainer;
    private $contentWrapper;
    private $tabBar;
    private $tabsContainer;
    private leftTabs;
    private rightTabs;
    private selectedTab;
    private hideTabBarIfSingleTab;
    private toolButtons;
    private windowButtons;
    private restoreFunction;
    constructor(config: UiTabPanelConfig, context: TeamAppsUiContext);
    setMaximized(maximized: boolean): void;
    maximize(): void;
    restore(): void;
    setFillTabBarWidth(fillTabBarWidth: boolean): any;
    setTabBarHeight(tabBarHeight: string): any;
    setHideTabBarIfSingleTab(hideTabBarIfSingleTab: boolean): void;
    private getAllTabs;
    doGetMainElement(): HTMLElement;
    private _createTab;
    private putTabButtonsToIndex;
    private createTabButton;
    selectTab(tabId: string, sendSelectionEvent?: boolean): void;
    setTabContent(tabId: string, content: UiComponent<UiComponentConfig>, fireLazyLoadEventIfNeeded?: boolean): void;
    setTabConfiguration(tabId: string, icon: string, caption: string, closeable: boolean, visible: boolean, rightSide: boolean): void;
    addTab(tabConfig: UiTabConfig, select: boolean, index?: number): void;
    moveTab(tabId: string, index: number): void;
    setTabToolbar(tabId: string, toolbar: UiToolbar): void;
    private setTabToolbarInternal;
    removeTab(tabId: string, warnIfNotFound?: boolean): void;
    private selectFirstVisibleTab;
    private onChildEmptyStateChanged;
    private updateEmptyState;
    private getTabById;
    private updateTabBarVisibility;
    get empty(): boolean;
    private getVisibleTabs;
    getNumberOfVisibleTabButtons(): number;
    private tabIsDeFactoEmpty;
    getSelectedTabId(): string;
    setToolButtons(toolButtons: UiToolButton[]): void;
    getToolButtons(): UiToolButton[];
    setWindowButtons(buttonTypes: UiWindowButtonType[]): void;
    private addWindowButton;
    removeWindowButton(uiToolButton: UiWindowButtonType): void;
    setTabStyle(tabStyle: UiTabPanelTabStyle): void;
    onResize(): void;
    private relayoutButtons;
}
