import { ScaleContinuousNumeric, ScaleTime } from "d3-scale";
import { SVGSelection } from "./Charting";
import { UiGraph } from "./UiGraph";
import { YAxis } from "./YAxis";
import { UiGraphConfig } from "../../generated/UiGraphConfig";
import { UiGraphDataConfig } from "../../generated/UiGraphDataConfig";
export declare abstract class AbstractUiGraph<C extends UiGraphConfig = UiGraphConfig, D extends UiGraphDataConfig = UiGraphDataConfig> implements UiGraph<C, D> {
    protected timeGraphId: string;
    protected config: C;
    protected scaleY: ScaleContinuousNumeric<number, number>;
    private yAxis;
    protected zoomLevelIndex: number;
    protected scaleX: ScaleTime<number, number>;
    protected $main: SVGSelection<any>;
    constructor(config: C, timeGraphId: string);
    protected abstract doRedraw(): void;
    abstract getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    abstract markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    abstract addData(zoomLevel: number, data: D): void;
    abstract resetData(): void;
    abstract getYDataBounds(xInterval: [number, number]): [number, number];
    getMainSelection(): SVGSelection<any>;
    updateZoomX(zoomLevelIndex: number, scaleX: ScaleTime<number, number>): void;
    redraw(): void;
    private getScaleYDomain;
    private updateYScale;
    setYRange(range: [number, number]): void;
    setConfig(config: C): void;
    protected getDisplayedIntervalX(): [number, number];
    destroy(): void;
    getConfig(): C;
    getYAxis(): YAxis;
}
