import { UiPanelHeaderFieldConfig } from "../generated/UiPanelHeaderFieldConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiWindowCommandHandler, UiWindowConfig, UiWindowEventSource, UiWindow_ClosedEvent } from "../generated/UiWindowConfig";
import { UiToolbar } from "./tool-container/toolbar/UiToolbar";
import { UiToolButton } from "./micro-components/UiToolButton";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiPanel_WindowButtonClickedEvent } from "../generated/UiPanelConfig";
import { UiWindowButtonType } from "../generated/UiWindowButtonType";
import { UiComponent } from "./UiComponent";
export declare class UiWindow extends AbstractUiComponent<UiWindowConfig> implements UiWindowCommandHandler, UiWindowEventSource {
    readonly onWindowButtonClicked: TeamAppsEvent<UiPanel_WindowButtonClickedEvent>;
    readonly onClosed: TeamAppsEvent<UiWindow_ClosedEvent>;
    private $main;
    private $panelWrapper;
    private panel;
    private escapeKeyListener;
    private clickOutsideListener;
    constructor(config: UiWindowConfig, context: TeamAppsUiContext);
    show(animationDuration: number): void;
    private removeBodyClickAndEscapeListeners;
    doGetMainElement(): HTMLElement;
    close(animationDuration: number, fireEvent?: boolean): void;
    setContent(content: UiComponent): void;
    setLeftHeaderField(field: UiPanelHeaderFieldConfig): void;
    setRightHeaderField(field: UiPanelHeaderFieldConfig): void;
    setToolbar(toolbar: UiToolbar): void;
    setMaximized(maximized: boolean): void;
    setToolButtons(toolButtons: UiToolButton[]): void;
    setIcon(icon: string): void;
    setTitle(title: string): void;
    setBadge(badge: string): void;
    setCloseOnClickOutside(closeOnClickOutside: boolean): void;
    setCloseOnEscape(closeOnEscape: boolean): void;
    setCloseable(closeable: boolean): void;
    setModalBackgroundDimmingColor(modalBackgroundDimmingColor: string): void;
    setModal(modal: boolean): void;
    setSize(width: number, height: number): void;
    setStretchContent(stretch: boolean): void;
    destroy(): void;
    setWindowButtons(windowButtons: UiWindowButtonType[]): void;
}
