import { TrivialComboBox } from "../../trivial-components/TrivialComboBox";
import { DateSuggestionEngine } from "./DateSuggestionEngine";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { UiField } from "../UiField";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiDateTimeFormatDescriptorConfig } from "../../../generated/UiDateTimeFormatDescriptorConfig";
import { LocalDateTime } from "../../datetime/LocalDateTime";
import { UiLocalDateFieldCommandHandler, UiLocalDateFieldConfig, UiLocalDateFieldEventSource } from "../../../generated/UiLocalDateFieldConfig";
import { UiLocalDateConfig } from "../../../generated/UiLocalDateConfig";
export declare class UiLocalDateField extends UiField<UiLocalDateFieldConfig, UiLocalDateConfig> implements UiLocalDateFieldEventSource, UiLocalDateFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    protected trivialComboBox: TrivialComboBox<LocalDateTime>;
    protected dateSuggestionEngine: DateSuggestionEngine;
    protected dateRenderer: (time: LocalDateTime) => string;
    private calendarBoxDropdown;
    protected initialize(config: UiLocalDateFieldConfig, context: TeamAppsUiContext): void;
    private getDefaultDate;
    protected localDateTimeToString(entry: LocalDateTime): string;
    protected createDateRenderer(): (time: LocalDateTime) => string;
    private updateDateSuggestionEngine;
    getMainInnerDomElement(): HTMLElement;
    protected initFocusHandling(): void;
    focus(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    isValidData(v: UiLocalDateConfig): boolean;
    protected displayCommittedValue(): void;
    getTransientValue(): UiLocalDateConfig;
    getReadOnlyHtml(value: UiLocalDateConfig, availableWidth: number): string;
    valuesChanged(v1: UiLocalDateConfig, v2: UiLocalDateConfig): boolean;
    private static UiLocalDateToLocalDateTime;
    destroy(): void;
    update(config: UiLocalDateFieldConfig): any;
    setLocaleAndDateFormat(locale: string, dateFormat: UiDateTimeFormatDescriptorConfig): void;
    setFavorPastDates(favorPastDates: boolean): void;
    setShowDropDownButton(showDropDownButton: boolean): void;
    setShowClearButton(showClearButton: boolean): void;
    setCalendarIconEnabled(calendarIconEnabled: boolean): void;
}
