import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiNavigationBarButtonConfig } from "../generated/UiNavigationBarButtonConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiNavigationBar_ButtonClickedEvent, UiNavigationBar_FanoutClosedDueToClickOutsideFanoutEvent, UiNavigationBarCommandHandler, UiNavigationBarConfig, UiNavigationBarEventSource } from "../generated/UiNavigationBarConfig";
import { UiComponent } from "./UiComponent";
import { UiMultiProgressDisplay } from "./UiDefaultMultiProgressDisplay";
export declare class UiNavigationBar extends AbstractUiComponent<UiNavigationBarConfig> implements UiNavigationBarCommandHandler, UiNavigationBarEventSource {
    readonly onButtonClicked: TeamAppsEvent<UiNavigationBar_ButtonClickedEvent>;
    readonly onFanoutClosedDueToClickOutsideFanout: TeamAppsEvent<UiNavigationBar_FanoutClosedDueToClickOutsideFanoutEvent>;
    private $bar;
    private $buttonsContainer;
    private buttons;
    private buttonTemplateRenderer;
    private $fanOutContainerWrapper;
    private $fanOutContainer;
    private fanOutComponents;
    private currentFanOutComponent;
    private fanoutClickOutsideHandle;
    private multiProgressDisplay;
    private $multiProgressDisplayContainer;
    constructor(config: UiNavigationBarConfig, context: TeamAppsUiContext);
    setBackgroundColor(color: string): void;
    setBorderColor(color: string): void;
    doGetMainElement(): HTMLElement;
    setButtons(buttons: UiNavigationBarButtonConfig[]): void;
    private addButton;
    setButtonVisible(buttonId: string, visible: boolean): void;
    addFanOutComponent(fanOutComponent: UiComponent): void;
    removeFanOutComponent(fanOutComponent: UiComponent): void;
    showFanOutComponent(fanOutComponent: UiComponent): void;
    hideFanOutComponent(): void;
    onResize(): void;
    private findNearestParentWithHiddenVerticalOverflow;
    setMultiProgressDisplay(multiProgressDisplay: UiMultiProgressDisplay): void;
}
