import { AbstractUiToolContainer } from "../AbstractUiToolContainer";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiToolbarButtonGroupConfig } from "../../../generated/UiToolbarButtonGroupConfig";
import { UiToolbarButtonConfig } from "../../../generated/UiToolbarButtonConfig";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiToolAccordionCommandHandler, UiToolAccordionConfig, UiToolAccordionEventSource } from "../../../generated/UiToolAccordionConfig";
import { AbstractUiToolContainer_ToolbarButtonClickEvent } from "../../../generated/AbstractUiToolContainerConfig";
import { UiComponent } from "../../UiComponent";
export declare class UiToolAccordion extends AbstractUiToolContainer<UiToolAccordionConfig> implements UiToolAccordionCommandHandler, UiToolAccordionEventSource {
    readonly onToolbarButtonClick: TeamAppsEvent<AbstractUiToolContainer_ToolbarButtonClickEvent>;
    private buttonGroupsById;
    private $mainDomElement;
    private $backgroundColorDiv;
    constructor(config: UiToolAccordionConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    private createButtonGroup;
    setButtonHasDropDown(groupId: string, buttonId: string, hasDropDown: boolean): void;
    setDropDownComponent(groupId: string, buttonId: string, component: UiComponent): void;
    closeDropDown(groupId: string, buttonId: string): void;
    setButtonVisible(groupId: string, buttonId: string, visible: boolean): void;
    setButtonColors(groupId: string, buttonId: string, backgroundColor: string, hoverBackgroundColor: string): void;
    setButtonGroupVisible(groupId: string, visible: boolean): void;
    addButtonGroup(buttonGroupConfig: UiToolbarButtonGroupConfig): void;
    removeButtonGroup(groupId: string): void;
    addButton(groupId: string, buttonConfig: UiToolbarButtonConfig, neighborButtonId: string, beforeNeighbor: boolean): void;
    removeButton(groupId: string, buttonId: string): void;
    updateButtonGroups(buttonGroups: UiToolbarButtonGroupConfig[]): void;
    refreshforcedButtonWidth(): void;
    onResize(): void;
}
