import { ScaleTime } from "d3-scale";
import { SVGSelection } from "./Charting";
import { YAxis } from "./YAxis";
import { UiGraphDataConfig } from "../../generated/UiGraphDataConfig";
import { UiGraphConfig } from "../../generated/UiGraphConfig";
export interface UiGraph<C extends UiGraphConfig = UiGraphConfig, D extends UiGraphDataConfig = UiGraphDataConfig> {
    setConfig(config: C): void;
    getMainSelection(): SVGSelection<any>;
    updateZoomX(zoomLevelIndex: number, scaleX: ScaleTime<number, number>): void;
    getYAxis(): YAxis | null;
    setYRange(range: [number, number]): void;
    redraw(): void;
    getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    addData(zoomLevel: number, data: D): void;
    resetData(): void;
    destroy(): void;
}
