/// <reference types="jquery" />
import "bootstrap-notify";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiEntranceAnimation } from "../generated/UiEntranceAnimation";
import { UiExitAnimation } from "../generated/UiExitAnimation";
import { UiPageDisplayMode } from "../generated/UiPageDisplayMode";
import { UiNotification_Position } from "../generated/UiNotificationConfig";
import { UiColorConfig } from "../generated/UiColorConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiTextMatchingMode } from "../generated/UiTextMatchingMode";
import { UiComponent } from "./UiComponent";
import { UiPageTransition } from "../generated/UiPageTransition";
export declare type RenderingFunction = (data: any) => string;
export declare type Renderer = {
    render: RenderingFunction;
    template: UiTemplateConfig;
};
export declare class Constants {
    private static _SCROLLBAR_WIDTH;
    static ENTRANCE_ANIMATION_CSS_CLASSES: {
        [UiEntranceAnimation.LIGHTSPEED_IN]: string;
        [UiEntranceAnimation.ROLL_IN]: string;
        [UiEntranceAnimation.ZOOM_IN]: string;
        [UiEntranceAnimation.ZOOM_IN_DOWN]: string;
        [UiEntranceAnimation.ZOOM_IN_LEFT]: string;
        [UiEntranceAnimation.ZOOM_IN_RIGHT]: string;
        [UiEntranceAnimation.ZOOM_IN_UP]: string;
        [UiEntranceAnimation.SLIDE_IN_UP]: string;
        [UiEntranceAnimation.SLIDE_IN_DOWN]: string;
        [UiEntranceAnimation.SLIDE_IN_LEFT]: string;
        [UiEntranceAnimation.SLIDE_IN_RIGHT]: string;
        [UiEntranceAnimation.ROTATE_IN]: string;
        [UiEntranceAnimation.ROTATE_IN_DOWNLEFT]: string;
        [UiEntranceAnimation.ROTATE_IN_DOWNRIGHT]: string;
        [UiEntranceAnimation.ROTATE_IN_UPLEFT]: string;
        [UiEntranceAnimation.ROTATE_IN_UPRIGHT]: string;
        [UiEntranceAnimation.FLIP_IN_X]: string;
        [UiEntranceAnimation.FLIP_IN_Y]: string;
        [UiEntranceAnimation.FADE_IN]: string;
        [UiEntranceAnimation.FADE_IN_DOWN]: string;
        [UiEntranceAnimation.FADE_IN_DOWNBIG]: string;
        [UiEntranceAnimation.FADE_IN_LEFT]: string;
        [UiEntranceAnimation.FADE_IN_LEFTBIG]: string;
        [UiEntranceAnimation.FADE_IN_RIGHT]: string;
        [UiEntranceAnimation.FADE_IN_RIGHTBIG]: string;
        [UiEntranceAnimation.FADE_IN_UP]: string;
        [UiEntranceAnimation.FADE_IN_UPBIG]: string;
        [UiEntranceAnimation.BOUNCE_IN]: string;
        [UiEntranceAnimation.BOUNCE_IN_DOWN]: string;
        [UiEntranceAnimation.BOUNCE_IN_LEFT]: string;
        [UiEntranceAnimation.BOUNCE_IN_RIGHT]: string;
        [UiEntranceAnimation.BOUNCE_IN_UP]: string;
    };
    static EXIT_ANIMATION_CSS_CLASSES: {
        [UiExitAnimation.LIGHTSPEED_OUT]: string;
        [UiExitAnimation.ROLL_OUT]: string;
        [UiExitAnimation.HINGE]: string;
        [UiExitAnimation.ZOOM_OUT]: string;
        [UiExitAnimation.ZOOM_OUT_DOWN]: string;
        [UiExitAnimation.ZOOM_OUT_LEFT]: string;
        [UiExitAnimation.ZOOM_OUT_RIGHT]: string;
        [UiExitAnimation.ZOOM_OUT_UP]: string;
        [UiExitAnimation.SLIDE_OUT_UP]: string;
        [UiExitAnimation.SLIDE_OUT_DOWN]: string;
        [UiExitAnimation.SLIDE_OUT_LEFT]: string;
        [UiExitAnimation.SLIDE_OUT_RIGHT]: string;
        [UiExitAnimation.ROTATE_OUT]: string;
        [UiExitAnimation.ROTATE_OUT_DOWNLEFT]: string;
        [UiExitAnimation.ROTATE_OUT_DOWNRIGHT]: string;
        [UiExitAnimation.ROTATE_OUT_UPLEFT]: string;
        [UiExitAnimation.ROTATE_OUT_UPRIGHT]: string;
        [UiExitAnimation.FLIP_OUT_X]: string;
        [UiExitAnimation.FLIP_OUT_Y]: string;
        [UiExitAnimation.FADE_OUT]: string;
        [UiExitAnimation.FADE_OUT_DOWN]: string;
        [UiExitAnimation.FADE_OUT_DOWNBIG]: string;
        [UiExitAnimation.FADE_OUT_LEFT]: string;
        [UiExitAnimation.FADE_OUT_LEFTBIG]: string;
        [UiExitAnimation.FADE_OUT_RIGHT]: string;
        [UiExitAnimation.FADE_OUT_RIGHTBIG]: string;
        [UiExitAnimation.FADE_OUT_UP]: string;
        [UiExitAnimation.FADE_OUT_UPBIG]: string;
        [UiExitAnimation.BOUNCE_OUT]: string;
        [UiExitAnimation.BOUNCE_OUT_DOWN]: string;
        [UiExitAnimation.BOUNCE_OUT_LEFT]: string;
        [UiExitAnimation.BOUNCE_OUT_RIGHT]: string;
        [UiExitAnimation.BOUNCE_OUT_UP]: string;
    };
    static POINTER_EVENTS: {
        start: string;
        move: string;
        end: string;
    };
    static readonly SCROLLBAR_WIDTH: number;
    private static calculateScrollbarWidth;
}
export declare function hasVerticalScrollBar(element: HTMLElement): boolean;
export declare const matchingModesMapping: {
    [x in UiTextMatchingMode]: 'contains' | 'prefix' | 'prefix-word' | 'prefix-levenshtein' | 'levenshtein';
};
export declare function loadScriptAsynchronously(url: string, callback?: EventListener): void;
export interface ClickOutsideHandle {
    cancel: () => void;
}
export declare function doOnceOnClickOutsideElement(elements: Element | NodeList | Element[], handler: (e?: JQueryMouseEventObject) => any, useCapture?: boolean): ClickOutsideHandle;
export declare type TreeEntry = any & {
    __children?: TreeEntry[];
    _isFreeTextEntry?: boolean;
};
export declare function buildTreeEntryHierarchy(entryList: any[], idPropertyName: string, parentIdPropertyName: string): TreeEntry[];
export declare type NodeWithChildren<T> = T & {
    __children?: NodeWithChildren<T>[];
};
export declare function buildObjectTree<T extends object>(nodes: T[], idPropertyName: string, parentIdPropertyName: string): NodeWithChildren<T>[];
export declare function humanReadableFileSize(bytes: number, decimalK?: boolean): string;
export declare function generateUUID(startingWithCharacter?: boolean): string;
export declare function formatNumber(number: number, precision: number, decimalSeparator: string, thousandsSeparator: string): string;
export declare function formatDecimalNumber(integerNumber: number, precision: number, decimalSeparator: string, thousandsSeparator: string): string;
export declare function applyDisplayMode($outer: HTMLElement, $inner: HTMLElement, displayMode: UiPageDisplayMode | any, options?: {
    innerPreferedDimensions?: {
        width: number;
        height: number;
    };
    zoomFactor?: number;
    padding?: number;
    considerScrollbars?: Boolean;
}): void;
export declare function boundSelection(selection: {
    left: number;
    top: number;
    width: number;
    height: number;
}, bounds: {
    width: number;
    height: number;
}, aspectRatio?: number): {
    left: number;
    top: number;
    width: number;
    height: number;
};
export declare function enterFullScreen(component: UiComponent<UiComponentConfig>): void;
export declare function isFullScreen(): boolean;
export declare function exitFullScreen(): void;
export declare function positionDropDown($button: Element, $dropDown: HTMLElement, { viewPortPadding, minHeightBeforeFlipping }: {
    viewPortPadding?: number;
    minHeightBeforeFlipping?: number;
}): void;
export declare function manipulateWithoutTransitions($element: HTMLElement, action: Function, transitionEnabled?: boolean): void;
export declare function focusNextByTabIndex(navigatableElements: HTMLElement[], navDirection: -1 | 1): boolean;
export declare function escapeHtml(string: string): string;
export declare function capitalizeFirstLetter(string: string): string;
export declare function logException(e: any, additionalString?: string): void;
export declare function stableSort<T>(arr: T[], cmpFunc: (a: T, b: T) => number): T[];
export declare function showNotification(html: string, config?: {
    backgroundColor?: UiColorConfig;
    position?: UiNotification_Position;
    displayTimeInMillis?: number;
    dismissable?: boolean;
    showProgressBar?: boolean;
    entranceAnimation?: UiEntranceAnimation;
    exitAnimation?: UiExitAnimation;
}): void;
export declare function getMicrosoftBrowserVersion(): number | false;
export declare function getIconPath(context: TeamAppsUiContext, iconName: string, iconSize: number, ignoreRetina?: boolean): string;
export declare function enableScrollViaDragAndDrop($scrollContainer: HTMLElement): void;
export declare function arraysEqual(a: any[], b: any[]): boolean;
export declare function convertJavaDateTimeFormatToMomentDateTimeFormat(javaFormat: string): string;
export declare function insertAtIndex($parent: Element, $child: Element, index: number): void;
export declare function maximizeComponent(component: UiComponent, maximizeAnimationCallback?: () => void): (restoreAnimationCallback?: () => void) => void;
export declare function flattenArray<T>(array: (T | T[])[]): T[];
export declare function removeTags(value: string, ...tagNames: string[]): string;
export declare function removeDangerousTags(value: string): string;
export declare function selectElementContents(domElement: Node, start?: number, end?: number): void;
export declare function parseHtml<E extends HTMLElement>(htmlString: string): E;
export declare function parseSvg<E extends Element>(htmlString: string): E;
export declare function prependChild(parent: Element, child: Element): void;
export declare function insertBefore(newNode: Element, referenceNode: Element): void;
export declare function insertAfter(newNode: Element, referenceNode: Element): void;
export declare function outerWidthIncludingMargins(el: HTMLElement): number;
export declare function outerHeightIncludingMargins(el: HTMLElement): number;
export declare function closestAncestor(el: HTMLElement, selector: string, includeSelf?: boolean): HTMLElement;
export declare function closestAncestorMatching(el: Element, predicate: (ancestor: Element) => boolean, includeSelf?: boolean): Element;
export declare function isDescendantOf(child: Element, potentialAncestor: Element, includeSelf?: boolean): Node & ParentNode;
export declare function createImageThumbnailUrl(file: File): Promise<string>;
export declare function removeClassesByFunction(classList: DOMTokenList, deleteDecider: (className: string) => boolean): void;
export declare function animateCSS(el: HTMLElement, animationName: "bounce" | "flash" | "pulse" | "rubberBand" | "shake" | "headShake" | "swing" | "tada" | "wobble" | "jello" | "bounceIn" | "bounceInDown" | "bounceInLeft" | "bounceInRight" | "bounceInUp" | "bounceOut" | "bounceOutDown" | "bounceOutLeft" | "bounceOutRight" | "bounceOutUp" | "fadeIn" | "fadeInDown" | "fadeInDownBig" | "fadeInLeft" | "fadeInLeftBig" | "fadeInRight" | "fadeInRightBig" | "fadeInUp" | "fadeInUpBig" | "fadeOut" | "fadeOutDown" | "fadeOutDownBig" | "fadeOutLeft" | "fadeOutLeftBig" | "fadeOutRight" | "fadeOutRightBig" | "fadeOutUp" | "fadeOutUpBig" | "flipInX" | "flipInY" | "flipOutX" | "flipOutY" | "lightSpeedIn" | "lightSpeedOut" | "rotateIn" | "rotateInDownLeft" | "rotateInDownRight" | "rotateInUpLeft" | "rotateInUpRight" | "rotateOut" | "rotateOutDownLeft" | "rotateOutDownRight" | "rotateOutUpLeft" | "rotateOutUpRight" | "hinge" | "jackInTheBox" | "rollIn" | "rollOut" | "zoomIn" | "zoomInDown" | "zoomInLeft" | "zoomInRight" | "zoomInUp" | "zoomOut" | "zoomOutDown" | "zoomOutLeft" | "zoomOutRight" | "zoomOutUp" | "slideInDown" | "slideInLeft" | "slideInRight" | "slideInUp" | "slideOutDown" | "slideOutLeft" | "slideOutRight" | "slideOutUp" | "heartBeat", animationDuration?: number, callback?: () => any): void;
export declare function fadeOut(el: HTMLElement): void;
export declare function fadeIn(el: HTMLElement): void;
export declare var pageTransitionAnimationPairs: {
    'moveToLeftVsMoveFromRight': {
        outClass: string[];
        inClass: string[];
    };
    'moveToRightVsMoveFromLeft': {
        outClass: string[];
        inClass: string[];
    };
    'moveToTopVsMoveFromBottom': {
        outClass: string[];
        inClass: string[];
    };
    'moveToBottomVsMoveFromTop': {
        outClass: string[];
        inClass: string[];
    };
    'fadeVsMoveFromRight': {
        outClass: string[];
        inClass: string[];
    };
    'fadeVsMoveFromLeft': {
        outClass: string[];
        inClass: string[];
    };
    'fadeVsMoveFromBottom': {
        outClass: string[];
        inClass: string[];
    };
    'fadeVsMoveFromTop': {
        outClass: string[];
        inClass: string[];
    };
    'moveToLeftFadeVsMoveFromRightFade': {
        outClass: string[];
        inClass: string[];
    };
    'moveToRightFadeVsMoveFromLeftFade': {
        outClass: string[];
        inClass: string[];
    };
    'moveToTopFadeVsMoveFromBottomFade': {
        outClass: string[];
        inClass: string[];
    };
    'moveToBottomFadeVsMoveFromTopFade': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownVsMoveFromRight': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownVsMoveFromLeft': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownVsMoveFromBottom': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownVsMoveFromTop': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownVsScaleUpDown': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownUpVsScaleUp': {
        outClass: string[];
        inClass: string[];
    };
    'moveToLeftVsScaleUp': {
        outClass: string[];
        inClass: string[];
    };
    'moveToRightVsScaleUp': {
        outClass: string[];
        inClass: string[];
    };
    'moveToTopVsScaleUp': {
        outClass: string[];
        inClass: string[];
    };
    'moveToBottomVsScaleUp': {
        outClass: string[];
        inClass: string[];
    };
    'scaleDownCenterVsScaleUpCenter': {
        outClass: string[];
        inClass: string[];
    };
    'rotateRightSideFirstVsMoveFromRight': {
        outClass: string[];
        inClass: string[];
    };
    'rotateLeftSideFirstVsMoveFromLeft': {
        outClass: string[];
        inClass: string[];
    };
    'rotateTopSideFirstVsMoveFromTop': {
        outClass: string[];
        inClass: string[];
    };
    'rotateBottomSideFirstVsMoveFromBottom': {
        outClass: string[];
        inClass: string[];
    };
    'flipOutRightVsFlipInLeft': {
        outClass: string[];
        inClass: string[];
    };
    'flipOutLeftVsFlipInRight': {
        outClass: string[];
        inClass: string[];
    };
    'flipOutTopVsFlipInBottom': {
        outClass: string[];
        inClass: string[];
    };
    'flipOutBottomVsFlipInTop': {
        outClass: string[];
        inClass: string[];
    };
    'rotateFallVsScaleUp': {
        outClass: string[];
        inClass: string[];
    };
    'rotateOutNewspaperVsRotateInNewspaper': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushLeftVsMoveFromRight': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushRightVsMoveFromLeft': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushTopVsMoveFromBottom': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushBottomVsMoveFromTop': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushLeftVsRotatePullRight': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushRightVsRotatePullLeft': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushTopVsRotatePullBottom': {
        outClass: string[];
        inClass: string[];
    };
    'rotatePushBottomVsRotatePullTop': {
        outClass: string[];
        inClass: string[];
    };
    'rotateFoldLeftVsMoveFromRightFade': {
        outClass: string[];
        inClass: string[];
    };
    'rotateFoldRightVsMoveFromLeftFade': {
        outClass: string[];
        inClass: string[];
    };
    'rotateFoldTopVsMoveFromBottomFade': {
        outClass: string[];
        inClass: string[];
    };
    'rotateFoldBottomVsMoveFromTopFade': {
        outClass: string[];
        inClass: string[];
    };
    'moveToRightFadeVsRotateUnfoldLeft': {
        outClass: string[];
        inClass: string[];
    };
    'moveToLeftFadeVsRotateUnfoldRight': {
        outClass: string[];
        inClass: string[];
    };
    'moveToBottomFadeVsRotateUnfoldTop': {
        outClass: string[];
        inClass: string[];
    };
    'moveToTopFadeVsRotateUnfoldBottom': {
        outClass: string[];
        inClass: string[];
    };
    'rotateRoomLeftOutVsRotateRoomLeftIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateRoomRightOutVsRotateRoomRightIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateRoomTopOutVsRotateRoomTopIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateRoomBottomOutVsRotateRoomBottomIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCubeLeftOutVsRotateCubeLeftIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCubeRightOutVsRotateCubeRightIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCubeTopOutVsRotateCubeTopIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCubeBottomOutVsRotateCubeBottomIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCarouselLeftOutVsRotateCarouselLeftIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCarouselRightOutVsRotateCarouselRightIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCarouselTopOutVsRotateCarouselTopIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateCarouselBottomOutVsRotateCarouselBottomIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateSidesOutVsRotateSidesIn': {
        outClass: string[];
        inClass: string[];
    };
    'rotateSlideOutVsRotateSlideIn': {
        outClass: string[];
        inClass: string[];
    };
};
export declare function animatePageTransition(outEl: HTMLElement, inEl: HTMLElement, animationName: keyof typeof pageTransitionAnimationPairs, animationDuration?: number, callback?: () => any): void;
export declare function pageTransition(outEl: HTMLElement, inEl: HTMLElement, pageTransition: UiPageTransition, animationDuration?: number, callback?: () => any): void;
export declare function css(el: HTMLElement, values: object): void;
export declare function getLastPointerCoordinates(): [number, number];
