import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiMapPolylineConfig } from "../generated/UiMapPolylineConfig";
import { UiMapMarkerClusterConfig } from "../generated/UiMapMarkerClusterConfig";
import { UiHeatMapDataConfig } from "../generated/UiHeatMapDataConfig";
import { UiMap_LocationChangedEvent, UiMap_MapClickedEvent, UiMap_MarkerClickedEvent, UiMap_ZoomLevelChangedEvent, UiMapCommandHandler, UiMapConfig, UiMapEventSource } from "../generated/UiMapConfig";
import { UiMapType } from "../generated/UiMapType";
import "leaflet.markercluster";
import "leaflet.heat";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiMapMarkerClientRecordConfig } from "../generated/UiMapMarkerClientRecordConfig";
import { UiMapLocationConfig } from "../generated/UiMapLocationConfig";
export declare class UiMap extends AbstractUiComponent<UiMapConfig> implements UiMapCommandHandler, UiMapEventSource {
    onZoomLevelChanged: TeamAppsEvent<UiMap_ZoomLevelChangedEvent>;
    onLocationChanged: TeamAppsEvent<UiMap_LocationChangedEvent>;
    onMapClicked: TeamAppsEvent<UiMap_MapClickedEvent>;
    onMarkerClicked: TeamAppsEvent<UiMap_MarkerClickedEvent>;
    private id;
    private leaflet;
    private tileLayer;
    private clusterLayer;
    private heatMapLayer;
    private markerTemplateRenderers;
    private $map;
    private polyLinesById;
    private markersByClientId;
    constructor(config: UiMapConfig, context: TeamAppsUiContext);
    getMainDomElement(): HTMLElement;
    private createLeafletMap;
    addPolyline(lineId: string, polylineConfig: UiMapPolylineConfig): void;
    private convertToLatLng;
    addPolylinePoints(lineId: string, points: UiMapLocationConfig[]): void;
    removePolyline(lineId: string): void;
    addMarker(markerConfig: UiMapMarkerClientRecordConfig): void;
    removeMarker(id: number): void;
    private createMarker;
    setZoomLevel(zoomLevel: number): void;
    setMapType(mapType: UiMapType): void;
    setLocation(location: UiMapLocationConfig): void;
    private createLeafletLatLng;
    setMapMarkerCluster(clusterConfig: UiMapMarkerClusterConfig): void;
    setHeatMap(data: UiHeatMapDataConfig): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    fitBounds(southWest: UiMapLocationConfig, northEast: UiMapLocationConfig): void;
    onResize(): void;
    destroy(): void;
}
