/// <reference types="slickgrid" />
export declare class UiTableRowSelectionModel {
    private _options?;
    private static readonly DEFAULTS;
    onSelectedRangesChanged: Slick.Event<any>;
    private grid;
    private ranges;
    constructor(_options?: {
        selectActiveRow: boolean;
    });
    /**
     * An initializer function that will be called with an instance of the grid whenever a selection model is registered with setSelectionModel. The selection model can use this to initialize its state and subscribe to grid events.
     **/
    init(grid: Slick.Grid<any>): void;
    /**
     * A destructor function that will be called whenever a selection model is unregistered from the grid by a call to setSelectionModel with another selection model
     * or whenever a grid with this selection model is destroyed.
     * The selection model can use this destructor to unsubscribe from grid events and release all resources (remove DOM nodes, event listeners, etc.).
     **/
    destroy(): void;
    rangesToRows(ranges: Slick.Range[]): number[];
    private rowsToRanges;
    private getRowsRange;
    getSelectedRows(): number[];
    setSelectedRows(rows: number[]): void;
    setSelectedRanges(ranges: Slick.Range[]): void;
    getSelectedRanges(): Slick.Range[];
    private handleActiveCellChange;
    private handleKeyDown;
    private handleClick;
}
