import { AbstractUiMapShapeChangeConfig } from "../generated/AbstractUiMapShapeChangeConfig";
import { AbstractUiMapShapeConfig } from "../generated/AbstractUiMapShapeConfig";
import { UiHeatMapDataConfig } from "../generated/UiHeatMapDataConfig";
import { UiMap2_LocationChangedEvent, UiMap2_MapClickedEvent, UiMap2_MarkerClickedEvent, UiMap2_ShapeDrawnEvent, UiMap2_ZoomLevelChangedEvent, UiMap2CommandHandler, UiMap2Config, UiMap2EventSource } from "../generated/UiMap2Config";
import { UiMapLocationConfig } from "../generated/UiMapLocationConfig";
import { UiMapMarkerClientRecordConfig } from "../generated/UiMapMarkerClientRecordConfig";
import { UiMapMarkerClusterConfig } from "../generated/UiMapMarkerClusterConfig";
import { UiMapMarkersConfig } from "../generated/UiMapMarkersConfig";
import { UiMapShapeType } from "../generated/UiMapShapeType";
import { UiShapePropertiesConfig } from "../generated/UiShapePropertiesConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare class UiMap2 extends AbstractUiComponent<UiMap2Config> implements UiMap2EventSource, UiMap2CommandHandler {
    readonly onZoomLevelChanged: TeamAppsEvent<UiMap2_ZoomLevelChangedEvent>;
    readonly onLocationChanged: TeamAppsEvent<UiMap2_LocationChangedEvent>;
    readonly onMapClicked: TeamAppsEvent<UiMap2_MapClickedEvent>;
    readonly onMarkerClicked: TeamAppsEvent<UiMap2_MarkerClickedEvent>;
    readonly onShapeDrawn: TeamAppsEvent<UiMap2_ShapeDrawnEvent>;
    private readonly $map;
    private readonly map;
    private readonly draw;
    private drawingProperties;
    private markerTemplateRenderers;
    private markersByClientId;
    private clusterMarkerCache;
    private clusterSourceById;
    private shapesSourceById;
    private displayVoronoiCellsEnabled;
    private deferredExecutor;
    private readonly fillOpacity;
    constructor(config: UiMap2Config, context: TeamAppsUiContext);
    setStyleUrl(styleUrl: string): void;
    private createShapeFeatureByConfig;
    addShape(shapeId: string, shapeConfig: AbstractUiMapShapeConfig): Promise<void>;
    updateShape(shapeId: string, shape: AbstractUiMapShapeConfig): Promise<void>;
    changeShape(shapeId: string, change: AbstractUiMapShapeChangeConfig): Promise<void>;
    removeShape(shapeId: string): Promise<void>;
    private removeShapeFromTerraDraw;
    clearShapes(): Promise<void>;
    private initializeMarkerCluster;
    setMapMarkerCluster(config: UiMapMarkerClusterConfig): void;
    addMarkerToCluster(marker: UiMapMarkerClientRecordConfig): Promise<void>;
    private removeMarkerFromCluster;
    private clearClusterMarkerCache;
    addMarkers(markers: UiMapMarkersConfig): Promise<void[]>;
    addMarker(markerConfig: UiMapMarkerClientRecordConfig): Promise<void>;
    private addMarkerToMap;
    removeMarker(id: number | string): Promise<void>;
    clearMarkers(): Promise<void[]>;
    private createMarker;
    private updateVoronoiCells;
    setDisplayVoronoiCells(enable: boolean): void;
    private initializeHeatMap;
    setHeatMap(data: UiHeatMapDataConfig): void;
    private createDrawShapeStyles;
    private mapShapeTypeToTerraDrawMode;
    startDrawingShape(shapeType: UiMapShapeType, shapeProperties: UiShapePropertiesConfig): void;
    stopDrawingShape(): void;
    setZoomLevel(zoom: number): void;
    setLocation(location: UiMapLocationConfig, animationDurationMillis: number, targetZoomLevel: number): void;
    fitBounds(southWest: UiMapLocationConfig, northEast: UiMapLocationConfig): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    private createFeatureCollection;
    private createPolygonFeature;
    private createPointFeature;
    private createMarkerFeature;
    private createHeatMapDataElementFeature;
    private createLineStringFeature;
    private convertToPosition;
    private convertToLngLatLike;
    private convertToUiLocation;
    private flattenPositionArray;
    private calcCenterUiLocation;
    doGetMainElement(): HTMLElement;
    onResize(): void;
    private addDebugView;
}
