import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiTextColorMarkerField_TextSelectedEvent, UiTextColorMarkerFieldCommandHandler, UiTextColorMarkerFieldConfig, UiTextColorMarkerFieldEventSource } from "../../generated/UiTextColorMarkerFieldConfig";
import { UiTextColorMarkerFieldMarkerDefinitionConfig } from "../../generated/UiTextColorMarkerFieldMarkerDefinitionConfig";
import { UiTextColorMarkerFieldValueConfig } from "../../generated/UiTextColorMarkerFieldValueConfig";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiField } from "./UiField";
export declare class UiTextColorMarkerField extends UiField<UiTextColorMarkerFieldConfig, UiTextColorMarkerFieldValueConfig> implements UiTextColorMarkerFieldCommandHandler, UiTextColorMarkerFieldEventSource {
    readonly onTextSelected: TeamAppsEvent<UiTextColorMarkerField_TextSelectedEvent>;
    private $main;
    private $toolbarWrapper;
    private $editor;
    private markerDefinitions;
    private toolbarEnabled;
    private currentSelection;
    protected initialize(config: UiTextColorMarkerFieldConfig, context: TeamAppsUiContext): void;
    private getMarkerDefinitionById;
    setMarkerDefinitions(markerDefinitions: UiTextColorMarkerFieldMarkerDefinitionConfig[], newValue: UiTextColorMarkerFieldValueConfig): void;
    setMarker(markerDefinitionId: number, start: number, end: number, fireMarkerChangeEvent?: boolean): void;
    removeMarker(markerDefinitionId: number): void;
    private commitAndSetMarkers;
    private fireValueChangedEvent;
    valuesChanged(v1: UiTextColorMarkerFieldValueConfig, v2: UiTextColorMarkerFieldValueConfig): boolean;
    private textChanged;
    private markersChanged;
    getTransientValue(): UiTextColorMarkerFieldValueConfig;
    private getTransientText;
    private getTransientMarkers;
    setValue(value: UiTextColorMarkerFieldValueConfig): void;
    private normalizeMarkers;
    protected displayCommittedValue(): void;
    private renderWithMarkers;
    private escapeHtml;
    private escapeHtmlAttr;
    private setupEventListeners;
    setToolbarEnabled(enabled: boolean): void;
    private triggerSelection;
    private triggerDeselection;
    private showToolbar;
    private hideToolbar;
    private updateToolbarContent;
    private getContrastColor;
    private getNodePosition;
    getDefaultValue(): UiTextColorMarkerFieldValueConfig;
    getMainInnerDomElement(): HTMLElement;
    focus(): void;
    isValidData(v: any): boolean;
    private isMarkerValid;
    private isMarkerOutOfRange;
    private isMarkerOverlappedButNotNested;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode, oldEditingMode?: UiFieldEditingMode): void;
    private isMarkerChangeAllowed;
    private createFieldValue;
    private createMarker;
}
