import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiToolButton_ClickedEvent, UiToolButton_DropDownOpenedEvent, UiToolButtonCommandHandler, UiToolButtonConfig, UiToolButtonEventSource } from "../../generated/UiToolButtonConfig";
import { AbstractUiComponent } from "../AbstractUiComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComponent } from "../UiComponent";
export declare class UiToolButton extends AbstractUiComponent<UiToolButtonConfig> implements UiToolButtonEventSource, UiToolButtonCommandHandler {
    readonly onClicked: TeamAppsEvent<UiToolButton_ClickedEvent>;
    readonly onDropDownOpened: TeamAppsEvent<UiToolButton_DropDownOpenedEvent>;
    private $button;
    private $icon;
    private $caption;
    private _dropDown;
    private dropDownComponent;
    private minDropDownWidth;
    private minDropDownHeight;
    private openDropDownIfNotSet;
    constructor(config: UiToolButtonConfig, context: TeamAppsUiContext);
    private get dropDown();
    doGetMainElement(): HTMLElement;
    setDropDownSize(minDropDownWidth: number, minDropDownHeight: number): void;
    setDropDownComponent(component: UiComponent): void;
    closeDropDown(): void;
    setOpenDropDownIfNotSet(openDropDownIfNotSet: boolean): void;
    setGrayOutIfNotHovered(grayOutIfNotHovered: boolean): void;
    setIcon(icon: string): void;
    setIconSize(iconSize: number | null): any;
    setCaption(caption: string): void;
    setTitle(title: string): void;
}
