import { ContextMenuEvent, TrivialTreeBox, TrivialTreeBoxConfig } from "./TrivialTreeBox";
import { TrivialComponent } from "./TrivialCore";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export interface TrivialTreeConfig<E> extends TrivialTreeBoxConfig<E> {
    directSelectionViaArrowKeys?: boolean;
}
export declare class TrivialTree<E> implements TrivialComponent {
    private config;
    readonly onSelectedEntryChanged: TeamAppsEvent<E>;
    readonly onContextMenu: TeamAppsEvent<ContextMenuEvent<E>>;
    readonly onNodeExpansionStateChanged: TeamAppsEvent<{
        node: E;
        expanded: boolean;
    }>;
    private treeBox;
    private entries;
    private selectedEntryId;
    private $componentWrapper;
    constructor(options: TrivialTreeConfig<E>);
    updateEntries(newEntries: E[]): void;
    private findEntries;
    private findEntryById;
    private setSelectedEntry;
    private fireChangeEvents;
    getSelectedEntry(): E;
    updateChildren(parentNodeId: any, children: E[]): void;
    updateNode(node: E): void;
    removeNode(nodeId: string | number): void;
    addNode(parentNodeId: string | number, node: E): void;
    addOrUpdateNode(parentNodeId: string | number, node: E, recursiveUpdate?: boolean): void;
    selectNodeById(nodeId: any): void;
    getTreeBox(): TrivialTreeBox<E>;
    destroy(): void;
    getMainDomElement(): HTMLElement;
}
