/// <reference types="d3-format" />
import { AbstractUiComponent } from "../AbstractUiComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { ScaleTime } from "d3-scale";
import { UiTimeGraphDataPointConfig } from "../../generated/UiTimeGraphDataPointConfig";
import { UiTimeGraph_DataNeededEvent, UiTimeGraph_IntervalSelectedEvent, UiTimeGraph_ZoomedEvent, UiTimeGraphCommandHandler, UiTimeGraphConfig, UiTimeGraphEventSource } from "../../generated/UiTimeGraphConfig";
import { UiLongIntervalConfig } from "../../generated/UiLongIntervalConfig";
import { UiLineChartLineConfig } from "../../generated/UiLineChartLineConfig";
import { UiLineChartMouseScrollZoomPanMode } from "../../generated/UiLineChartMouseScrollZoomPanMode";
import { UiTimeChartZoomLevelConfig } from "../../generated/UiTimeChartZoomLevelConfig";
export declare const yTickFormat: (n: number | {
    valueOf(): number;
}) => string;
export declare class UiTimeGraph extends AbstractUiComponent<UiTimeGraphConfig> implements UiTimeGraphCommandHandler, UiTimeGraphEventSource {
    readonly onDataNeeded: TeamAppsEvent<UiTimeGraph_DataNeededEvent>;
    readonly onIntervalSelected: TeamAppsEvent<UiTimeGraph_IntervalSelectedEvent>;
    readonly onZoomed: TeamAppsEvent<UiTimeGraph_ZoomedEvent>;
    static readonly LOGSCALE_MIN_Y = 0.5;
    static readonly DROP_SHADOW_ID = "drop-shadow";
    private mouseScrollZoomPanMode;
    private intervalX;
    private maxPixelsBetweenDataPoints;
    private linesById;
    private $main;
    private $svg;
    private $rootG;
    private $dropShadowFilter;
    private $clipPath;
    private scaleX;
    private dropShadowFilterId;
    private margin;
    private zoom;
    private xAxis;
    private $xAxis;
    private $horizontalPanRect;
    private zoomLevelIntervalManagers;
    private brush;
    private $brush;
    private $graphClipContainer;
    private xSelection;
    private zoomLevels;
    private $yAxisContainer;
    private lastDrawableWidth;
    private dataStore;
    readonly drawableWidth: number;
    private readonly drawableHeight;
    private readonly marginLeft;
    constructor(config: UiTimeGraphConfig, context: TeamAppsUiContext);
    private createSeries;
    getZoomBoundsX(): number[];
    getTransformedScaleX(): ScaleTime<number, number>;
    private initZoomLevelIntervalManagers;
    private redraw;
    private restrictDomainXToConfiguredInterval;
    getCurrentZoomLevel(): number;
    private getSortedZoomLevels;
    private handleBrushSelection;
    onResize(): void;
    private updateZoomExtents;
    private getAllSeries;
    addData(zoomLevel: number, intervalX: UiLongIntervalConfig, data: {
        [seriesId: string]: UiTimeGraphDataPointConfig[];
    }): void;
    resetAllData(newZoomLevels: UiTimeChartZoomLevelConfig[]): void;
    replaceAllData(newZoomLevels: UiTimeChartZoomLevelConfig[], zoomLevel: number, intervalX: UiLongIntervalConfig, data: {
        [seriesId: string]: UiTimeGraphDataPointConfig[];
    }): void;
    setIntervalX(intervalX: UiLongIntervalConfig): void;
    setMouseScrollZoomPanMode(mouseScrollZoomPanMode: UiLineChartMouseScrollZoomPanMode): void;
    private fireUiZoomEvent;
    setSelectedInterval(intervalX: UiLongIntervalConfig): void;
    setMaxPixelsBetweenDataPoints(maxPixelsBetweenDataPoints: number): void;
    destroy(): void;
    getMainDomElement(): HTMLElement;
    private calculateMaxZoomFactor;
    setLines(lineConfigs: UiLineChartLineConfig[]): void;
    setLine(lineId: string, lineFormat: UiLineChartLineConfig): void;
}
