import { UiConfigurationConfig } from "../generated/UiConfigurationConfig";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiEvent } from "../generated/UiEvent";
import { TemplateRegistry } from "./TemplateRegistry";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiCommand } from "../generated/UiCommand";
import { UiComponent } from "./UiComponent";
export declare const typescriptDeclarationFixConstant = 1;
export interface IconPathProvider {
    getIconPath(iconName: string, iconSize: number, ignoreRetina?: boolean): string;
}
export interface TeamAppsUiContext extends IconPathProvider {
    readonly sessionId: string;
    readonly isHighDensityScreen: boolean;
    readonly executingCommand: boolean;
    readonly config: UiConfigurationConfig;
    readonly templateRegistry: TemplateRegistry;
    getComponentById(id: string): UiComponent<UiComponentConfig>;
}
export interface TeamAppsUiContextInternalApi extends TeamAppsUiContext {
    readonly onStaticMethodCommandInvocation: TeamAppsEvent<UiCommand>;
    registerComponent(component: UiComponent<UiComponentConfig>, id: string, teamappsType: string): void;
    createAndRegisterComponent(config: UiComponentConfig): UiComponent<UiComponentConfig>;
    destroyComponent(componentId: string): void;
    refreshComponent(config: UiComponentConfig): void;
    fireEvent(eventObject: UiEvent): void;
}
