/// <reference path="../../../ts/custom-declarations/d3v3.d.ts" />
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiMediaTrackGraph_HandleTimeSelectionEvent, UiMediaTrackGraphCommandHandler, UiMediaTrackGraphConfig, UiMediaTrackGraphEventSource } from "../generated/UiMediaTrackGraphConfig";
export declare class UiMediaTrackGraph extends AbstractUiComponent<UiMediaTrackGraphConfig> implements UiMediaTrackGraphCommandHandler, UiMediaTrackGraphEventSource {
    readonly onHandleTimeSelection: TeamAppsEvent<UiMediaTrackGraph_HandleTimeSelectionEvent>;
    private static MARGINS;
    private $graph;
    private brush;
    private brushExtent;
    private x;
    private xExtent;
    private trackCount;
    private areaElements;
    private lineElements;
    private areas;
    private lines;
    private xAxisElement;
    private svg;
    private xAxis;
    private markerGroup;
    private cursor;
    private audioUrl;
    private data;
    private markerData;
    constructor(config: UiMediaTrackGraphConfig, context: TeamAppsUiContext);
    getMainDomElement(): HTMLElement;
    private createBrush;
    private zoomFunc;
    private areaValue;
    private lineValue;
    private base;
    private createAudioPlayer;
    private brushedData;
    setCursorPosition(time: number): number;
    onResize(): void;
    destroy(): void;
}
