import { UiNotification_ClosedEvent, UiNotification_OpenedEvent, UiNotificationCommandHandler, UiNotificationConfig, UiNotificationEventSource } from "../generated/UiNotificationConfig";
import { UiEntranceAnimation } from "../generated/UiEntranceAnimation";
import { UiNotificationPosition } from "../generated/UiNotificationPosition";
import { UiExitAnimation } from "../generated/UiExitAnimation";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare function showNotification(notification: UiNotification, position: UiNotificationPosition, entranceAnimation: UiEntranceAnimation, exitAnimation: UiExitAnimation): void;
export declare class UiNotification extends AbstractUiComponent<UiNotificationConfig> implements UiNotificationCommandHandler, UiNotificationEventSource {
    readonly onOpened: TeamAppsEvent<UiNotification_OpenedEvent>;
    readonly onClosed: TeamAppsEvent<UiNotification_ClosedEvent>;
    readonly onClosedAnyWay: TeamAppsEvent<void>;
    private $main;
    private $contentContainer;
    private $progressBarContainer;
    private progressBar;
    constructor(config: UiNotificationConfig, context: TeamAppsUiContext);
    update(config: UiNotificationConfig): void;
    private closeTimeout;
    startCloseTimeout(): void;
    getMainDomElement(): HTMLElement;
    close(): void;
}
