import { UiPanelHeaderFieldConfig } from "../generated/UiPanelHeaderFieldConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiWindowCommandHandler, UiWindowConfig, UiWindowEventSource } from "../generated/UiWindowConfig";
import { UiColorConfig } from "../generated/UiColorConfig";
import { UiToolbar } from "./tool-container/toolbar/UiToolbar";
import { UiToolButton } from "./micro-components/UiToolButton";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiPanel_WindowButtonClickedEvent } from "../generated/UiPanelConfig";
import { UiWindowButtonType } from "../generated/UiWindowButtonType";
import { UiComponent } from "./UiComponent";
export interface UiWindowListener {
    onWindowClosed: (window: UiWindow, animationDuration: number) => void;
}
export declare class UiWindow extends AbstractUiComponent<UiWindowConfig> implements UiWindowCommandHandler, UiWindowEventSource {
    readonly onWindowButtonClicked: TeamAppsEvent<UiPanel_WindowButtonClickedEvent>;
    private $main;
    private $panelWrapper;
    private listener;
    private panel;
    private escapeKeyListener;
    private clickOutsideListener;
    private closeable;
    private closeOnEscape;
    private closeOnClickOutside;
    private modal;
    private modalBackgroundDimmingColor;
    constructor(config: UiWindowConfig, context: TeamAppsUiContext);
    show(animationDuration: number): void;
    private removeCloseEventListeners;
    getMainDomElement(): HTMLElement;
    setListener(listener: UiWindowListener): void;
    close(animationDuration: number): void;
    setContent(content: UiComponent): void;
    setLeftHeaderField(field: UiPanelHeaderFieldConfig): void;
    setRightHeaderField(field: UiPanelHeaderFieldConfig): void;
    setToolbar(toolbar: UiToolbar): void;
    setMaximized(maximized: boolean): void;
    setToolButtons(toolButtons: UiToolButton[]): void;
    setIcon(icon: string): void;
    setTitle(title: string): void;
    setCloseOnClickOutside(closeOnClickOutside: boolean): void;
    setCloseOnEscape(closeOnEscape: boolean): void;
    setCloseable(closeable: boolean): void;
    setModalBackgroundDimmingColor(modalBackgroundDimmingColor: UiColorConfig): void;
    setModal(modal: boolean): void;
    isModal(): boolean;
    setSize(width: number, height: number): void;
    setStretchContent(stretch: boolean): void;
    destroy(): void;
    setWindowButtons(windowButtons: UiWindowButtonType[]): void;
}
