import * as d3 from "d3";
import { BaseType, HierarchyPointNode, Selection } from "d3";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { UiTreeGraph_NodeClickedEvent, UiTreeGraph_NodeExpandedOrCollapsedEvent, UiTreeGraph_ParentExpandedOrCollapsedEvent, UiTreeGraph_SideListExpandedOrCollapsedEvent, UiTreeGraphCommandHandler, UiTreeGraphConfig, UiTreeGraphEventSource } from "../generated/UiTreeGraphConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiTreeGraphNodeConfig } from "../generated/UiTreeGraphNodeConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { FlexTreeLayout } from "d3-flextree";
export declare class UiTreeGraph extends AbstractUiComponent<UiTreeGraphConfig> implements UiTreeGraphCommandHandler, UiTreeGraphEventSource {
    readonly onNodeClicked: TeamAppsEvent<UiTreeGraph_NodeClickedEvent>;
    readonly onNodeExpandedOrCollapsed: TeamAppsEvent<UiTreeGraph_NodeExpandedOrCollapsedEvent>;
    readonly onParentExpandedOrCollapsed: TeamAppsEvent<UiTreeGraph_ParentExpandedOrCollapsedEvent>;
    readonly onSideListExpandedOrCollapsed: TeamAppsEvent<UiTreeGraph_SideListExpandedOrCollapsedEvent>;
    private chart;
    private $main;
    constructor(config: UiTreeGraphConfig, context: TeamAppsUiContext);
    update(config: UiTreeGraphConfig): void;
    moveToRootNode(): void;
    moveToNode(nodeId: string): void;
    setNodes(nodes: UiTreeGraphNodeConfig[]): void;
    addNode(node: UiTreeGraphNodeConfig): void;
    removeNode(nodeId: string): void;
    setNodeExpanded(nodeId: string, expanded: boolean): void;
    updateNode(node: UiTreeGraphNodeConfig): void;
    setZoomFactor(zoomFactor: number): void;
    getMainDomElement(): HTMLElement;
    onResize(): void;
}
interface TreeNode extends HierarchyPointNode<UiTreeGraphNodeConfig> {
    hasChildren?: boolean;
    sideListNodes: TreeNodeLike[];
}
interface TreeNodeLike {
    data: UiTreeGraphNodeConfig;
    id?: string;
    hasChildren?: boolean;
    parent?: TreeNode | null;
    x: number;
    y: number;
}
export interface Layouts {
    treemap: FlexTreeLayout<UiTreeGraphNodeConfig>;
}
export interface TreeChartAttributes {
    [key: string]: any;
    id: string;
    data?: UiTreeGraphNodeConfig[];
    root: TreeNode;
    svg: Selection<SVGElement, any, any, any>;
    svgWidth?: number;
    svgHeight?: number;
    marginTop?: number;
    marginBottom?: number;
    marginRight?: number;
    marginLeft?: number;
    container?: any;
    defaultTextFill?: string;
    defaultFont?: string;
    backgroundColor: string;
    duration: number;
    strokeWidth: number;
    dropShadowId: string;
    initialZoom: number;
    onNodeClick?: (name: string) => void;
    onNodeExpandedOrCollapsed?: (nodeId: string, expanded: boolean, lazyLoad: boolean) => void;
    onParentExpandedOrCollapsed?: (nodeId: string, expanded: boolean, lazyLoad: boolean) => void;
    onSideListExpandedOrCollapsed?: (nodeId: string, expanded: boolean) => void;
    verticalLayerGap: number;
    horizontalSiblingGap: number;
    horizontalNonSignlingGap: number;
    sideListIndent: number;
    sideListVerticalGap: number;
    defs: Selection<BaseType, unknown, SVGElement, void>;
    compact: boolean;
}
export interface PatternifyParameter {
    selector: string;
    tag: string;
    data?: any;
}
export declare function patternify<E extends BaseType, ED, P extends BaseType = null, PD = null>(container: Selection<P, PD, any, any>, params: PatternifyParameter): d3.Selection<E, ED, P, PD>;
export {};
