import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiInfiniteItemView_DataRequestEvent, UiInfiniteItemView_ItemClickedEvent, UiInfiniteItemViewCommandHandler, UiInfiniteItemViewConfig, UiInfiniteItemViewEventSource } from "../generated/UiInfiniteItemViewConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiItemJustification } from "../generated/UiItemJustification";
import { UiVerticalItemAlignment } from "../generated/UiVerticalItemAlignment";
export declare class UiInfiniteItemView extends AbstractUiComponent<UiInfiniteItemViewConfig> implements UiInfiniteItemViewCommandHandler, UiInfiniteItemViewEventSource {
    readonly onDataRequest: TeamAppsEvent<UiInfiniteItemView_DataRequestEvent>;
    readonly onItemClicked: TeamAppsEvent<UiInfiniteItemView_ItemClickedEvent>;
    private $mainDomElement;
    private $grid;
    private grid;
    private dataProvider;
    private itemTemplateRenderer;
    private uuid;
    private horizontalItemMargin;
    private itemWidth;
    private itemJustification;
    private verticalItemAlignment;
    constructor(config: UiInfiniteItemViewConfig, context: TeamAppsUiContext);
    private createGrid;
    private calculateItemWidthInPixels;
    addData(startIndex: number, data: any[], totalNumberOfRecords: number, clearTableCache: boolean): void;
    removeData(ids: number[]): void;
    onResize(): void;
    destroy(): void;
    doGetMainElement(): HTMLElement;
    private updateStyles;
    setHorizontalItemMargin(horizontalItemMargin: number): void;
    setVerticalItemAlignment(verticalItemAlignment: UiVerticalItemAlignment): void;
    setItemTemplate(itemTemplate: UiTemplateConfig): void;
    setItemWidth(itemWidth: number): void;
    setItemJustification(itemJustification: UiItemJustification): void;
}
