import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiField, ValueChangeEventData } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiCompositeSubFieldConfig } from "../../generated/UiCompositeSubFieldConfig";
import { UiCompositeFieldConfig } from "../../generated/UiCompositeFieldConfig";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
export declare type SubField = {
    config: UiCompositeSubFieldConfig;
    field: UiField;
    $cell: HTMLElement;
    visible?: boolean;
};
export declare type ColumnWidthConstraints = {
    width: number;
    minWidth: number;
};
export declare class UiCompositeField extends UiField<UiCompositeFieldConfig, any> {
    private static logger;
    readonly onSubFieldValueChanged: TeamAppsEvent<ValueChangeEventData & {
        fieldName: string;
        originalEmitter: UiField;
    }>;
    private subFields;
    private $wrapper;
    protected initialize(config: UiCompositeFieldConfig, context: TeamAppsUiContext): void;
    isValidData(v: any): boolean;
    private static validateNumberOfRowHeights;
    private getNextFocusableField;
    commit(forceEvenIfNotChanged?: boolean): boolean;
    private getSubFieldsSortedByTabOrder;
    private subFieldToString;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    protected displayCommittedValue(): void;
    private static updateSubFieldVisibilities;
    private static updateDeclaredSubfieldVisibilities;
    getTransientValue(): any;
    focus(): void;
    private getSubFieldByFieldName;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    private getAllUiFields;
    private getAllSubFields;
    doDestroy(): void;
    getReadOnlyHtml(value: any, availableWidth: number): string;
    private static createDomStructure;
    onResize(): void;
    private static applyLayout;
    static calculateColumnWidths(columnsWidthConstraints: ColumnWidthConstraints[], availableWidth: number): number[];
    setFieldValue(fieldName: string, value: any): void;
    focusField(fieldName: string): void;
    getSubFields(): SubField[];
    getDefaultValue(): {};
    valuesChanged(v1: any, v2: any): boolean;
}
