import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiToolbarCommandHandler, UiToolbarConfig, UiToolbarEventSource } from "../../../generated/UiToolbarConfig";
import { UiToolbarButtonGroupConfig } from "../../../generated/UiToolbarButtonGroupConfig";
import { UiToolbarButtonConfig } from "../../../generated/UiToolbarButtonConfig";
import { AbstractUiToolContainer } from "../AbstractUiToolContainer";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { AbstractUiToolContainer_ToolbarButtonClickEvent, AbstractUiToolContainer_ToolbarDropDownItemClickEvent } from "../../../generated/AbstractUiToolContainerConfig";
import { Emptyable } from "../../util/Emptyable";
import { UiToolbarButton } from "./UiToolbarButton";
import { UiComponent } from "../../UiComponent";
import { UiColorConfig } from "../../../generated/UiColorConfig";
interface FQButtonId {
    groupId: string;
    buttonId: string;
    button: UiToolbarButton;
}
export declare type ButtonVisibilities = {
    fittingButtons: FQButtonId[];
    nonFittingButtons: FQButtonId[];
    hiddenButtons: FQButtonId[];
};
export declare class UiToolbar extends AbstractUiToolContainer<UiToolbarConfig> implements Emptyable, UiToolbarCommandHandler, UiToolbarEventSource {
    readonly onEmptyStateChanged: TeamAppsEvent<boolean>;
    readonly onToolbarButtonClick: TeamAppsEvent<AbstractUiToolContainer_ToolbarButtonClickEvent>;
    readonly onToolbarDropDownItemClick: TeamAppsEvent<AbstractUiToolContainer_ToolbarDropDownItemClickEvent>;
    static DEFAULT_TOOLBAR_MAX_HEIGHT: number;
    private buttonGroupsById;
    private _$toolbar;
    private _$backgroundColorDiv;
    private _$innerContainer;
    private $toolbarFiller;
    private _$logo;
    private overflowDropDown;
    private overflowToolAccordion;
    private $overflowDropDownButton;
    private totalWidthOfOverflowButtons;
    constructor(config: UiToolbarConfig, context: TeamAppsUiContext);
    private createDropDownAccordion;
    doGetMainElement(): HTMLElement;
    setLogoImage(logoImage: string): void;
    setDropDownComponent(groupId: string, buttonId: string, component: UiComponent): void;
    setButtonHasDropDown(groupId: string, buttonId: string, hasDropDown: boolean): void;
    setButtonVisible(groupId: string, buttonId: string, visible: boolean): void;
    setButtonGroupVisible(groupId: string, visible: boolean): void;
    addButtonGroup(groupConfig: UiToolbarButtonGroupConfig): void;
    removeButtonGroup(groupId: string): void;
    addButton(groupId: string, buttonConfig: UiToolbarButtonConfig, neighborButtonId: string, beforeNeighbor: boolean): void;
    removeButton(groupId: string, buttonId: string): void;
    updateButtonGroups(buttonGroups: UiToolbarButtonGroupConfig[]): void;
    onResize(): void;
    private updateButtonOverflow;
    readonly empty: boolean;
    destroy(): void;
    setButtonColors(groupId: string, buttonId: string, backgroundColor: UiColorConfig, hoverBackgroundColor: UiColorConfig): void;
}
export {};
