import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiDocumentViewerCommandHandler, UiDocumentViewerConfig } from "../generated/UiDocumentViewerConfig";
import { UiPageDisplayMode } from "../generated/UiPageDisplayMode";
import { UiBorderConfig } from "../generated/UiBorderConfig";
import { UiShadowConfig } from "../generated/UiShadowConfig";
export declare class UiDocumentViewer extends AbstractUiComponent<UiDocumentViewerConfig> implements UiDocumentViewerCommandHandler {
    private $componentWrapper;
    private $pagesContainerWrapper;
    private $pagesContainer;
    private zoomFactor;
    private displayMode;
    private pages;
    private uuidClass;
    private $styleTag;
    private pageBorder;
    private pageSpacing;
    private pageShadow;
    constructor(config: UiDocumentViewerConfig, context: TeamAppsUiContext);
    setPageUrls(pageUrls: string[]): void;
    setDisplayMode(displayMode: UiPageDisplayMode, zoomFactor: number): void;
    setZoomFactor(zoomFactor: number): void;
    private updateImageSizes;
    onResize(): void;
    doGetMainElement(): HTMLElement;
    destroy(): void;
    setPageBorder(pageBorder: UiBorderConfig): void;
    setPaddding(padding: number): void;
    setPageSpacing(pageSpacing: number): void;
    setPageShadow(pageShadow: UiShadowConfig): void;
    private updateStyles;
}
