import { AbstractUiComponent } from "../../AbstractUiComponent";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiMediaSoupV2WebRtcClient_VoiceActivityChangedEvent, UiMediaSoupV2WebRtcClient_ClickedEvent, UiMediaSoupV2WebRtcClient_PlaybackProfileChangedEvent, UiMediaSoupV2WebRtcClientCommandHandler, UiMediaSoupV2WebRtcClientConfig, UiMediaSoupV2WebRtcClientEventSource } from "../../../generated/UiMediaSoupV2WebRtcClientConfig";
import { UiMediaSoupPlaybackParamatersConfig } from "../../../generated/UiMediaSoupPlaybackParamatersConfig";
import { UiMediaSoupPublishingParametersConfig } from "../../../generated/UiMediaSoupPublishingParametersConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
export declare class UiMediaSoupV2WebRtcClient extends AbstractUiComponent<UiMediaSoupV2WebRtcClientConfig> implements UiMediaSoupV2WebRtcClientCommandHandler, UiMediaSoupV2WebRtcClientEventSource {
    readonly onPlaybackProfileChanged: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PlaybackProfileChangedEvent>;
    readonly onVoiceActivityChanged: TeamAppsEvent<UiMediaSoupV2WebRtcClient_VoiceActivityChangedEvent>;
    readonly onClicked: TeamAppsEvent<UiMediaSoupV2WebRtcClient_ClickedEvent>;
    private $main;
    private conference;
    private $video;
    private $profileDisplay;
    private $icon;
    private $caption;
    private voiceActivityDetectionHandle;
    private multiStreamMixer;
    constructor(config: UiMediaSoupV2WebRtcClientConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    publish(parameters: UiMediaSoupPublishingParametersConfig): void;
    private getUserMedia;
    playback(parameters: UiMediaSoupPlaybackParamatersConfig): void;
    stop(): void;
    update(config: UiMediaSoupV2WebRtcClientConfig): void;
    setActive(active: boolean): void;
    private isVideoShown;
    onResize(): void;
    private static createVideoConstraints;
}
