import { UiTree_NodeSelectedEvent, UiTree_RequestTreeDataEvent, UiTree_TextInputEvent, UiTreeCommandHandler, UiTreeConfig, UiTreeEventSource } from "../generated/UiTreeConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiTreeRecordConfig } from "../generated/UiTreeRecordConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
export declare class UiTree extends AbstractUiComponent<UiTreeConfig> implements UiTreeCommandHandler, UiTreeEventSource {
    readonly onTextInput: TeamAppsEvent<UiTree_TextInputEvent>;
    readonly onNodeSelected: TeamAppsEvent<UiTree_NodeSelectedEvent>;
    readonly onRequestTreeData: TeamAppsEvent<UiTree_RequestTreeDataEvent>;
    private $panel;
    private trivialTree;
    private lastResultCallback;
    private nodes;
    private templateRenderers;
    constructor(config: UiTreeConfig, context: TeamAppsUiContext);
    private renderRecord;
    doGetMainElement(): HTMLElement;
    replaceData(nodes: UiTreeRecordConfig[]): void;
    bulkUpdate(nodesToBeRemoved: number[], nodesToBeAdded: UiTreeRecordConfig[]): void;
    setSelectedNode(recordId: number | null): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    destroy(): void;
}
