import { UiWebRtcPlayerCommandHandler, UiWebRtcPlayerConfig } from "../generated/UiWebRtcPlayerConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiWebRtcPlayingSettingsConfig } from "../generated/UiWebRtcPlayingSettingsConfig";
import { UiVideoCodec } from "../generated/UiVideoCodec";
export declare class UiWebRtcPlayer extends AbstractUiComponent<UiWebRtcPlayerConfig> implements UiWebRtcPlayerCommandHandler {
    private static readonly PEER_CONNECTION_CONFIG;
    private $main;
    private $videoContainer;
    private $audioActivityDisplayContainer;
    private $spinnerContainer;
    private remoteVideo;
    private peerConnection;
    private settings;
    private signalingWsConnection;
    private streamInfo;
    private userData;
    private iceConnectionState;
    constructor(config: UiWebRtcPlayerConfig, context: TeamAppsUiContext);
    static getPlayableVideoCodecs(): Promise<UiVideoCodec[]>;
    play(settings: UiWebRtcPlayingSettingsConfig): void;
    private reconnectForPlaying;
    stopPlaying(): void;
    private sendPlayGetOffer;
    private gotIceCandidate;
    private onPlayingIceConnectionStateChange;
    private updateUi;
    private gotDescriptionForPlaying;
    private gotRemoteTrack;
    private gotRemoteStream;
    private errorHandler;
    setBackgroundImageUrl(backgroundImageUrl: string): void;
    onResize(): void;
    destroy(): void;
    doGetMainElement(): HTMLElement;
}
