import { ClickOutsideHandle } from "../Common";
import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { UiComponent } from "../UiComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiSpinner } from "./UiSpinner";
interface OpenConfig {
    $reference: HTMLElement | Element;
    width?: number;
    viewPortPadding?: number;
    minHeight?: number;
}
export declare class UiDropDown {
    onClose: TeamAppsEvent<void>;
    onComponentRemoved: TeamAppsEvent<UiComponent>;
    protected $dropDown: HTMLElement;
    protected $contentContainer: HTMLElement;
    protected clickOutsideHandle: ClickOutsideHandle;
    protected spinner: UiSpinner;
    protected currentOpenConfig: OpenConfig;
    private _isOpen;
    private _contentComponent;
    constructor(content?: UiComponent<UiComponentConfig>);
    setContentComponent(component: UiComponent<UiComponentConfig>): void;
    open(config: OpenConfig): void;
    close(): void;
    readonly isOpen: boolean;
    getMainDomElement(): HTMLElement;
    getScrollContainer(): HTMLElement;
}
export {};
