import { AbstractUiComponent } from "../../AbstractUiComponent";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiMediaSoupV2WebRtcClient_ClickedEvent, UiMediaSoupV2WebRtcClient_ConnectionStateChangedEvent, UiMediaSoupV2WebRtcClient_PlaybackFailedEvent, UiMediaSoupV2WebRtcClient_PlaybackProfileChangedEvent, UiMediaSoupV2WebRtcClient_PlaybackSucceededEvent, UiMediaSoupV2WebRtcClient_PublishedStreamEndedEvent, UiMediaSoupV2WebRtcClient_PublishedStreamsStatusChangedEvent, UiMediaSoupV2WebRtcClient_PublishingFailedEvent, UiMediaSoupV2WebRtcClient_PublishingSucceededEvent, UiMediaSoupV2WebRtcClient_VoiceActivityChangedEvent, UiMediaSoupV2WebRtcClientCommandHandler, UiMediaSoupV2WebRtcClientConfig, UiMediaSoupV2WebRtcClientEventSource } from "../../../generated/UiMediaSoupV2WebRtcClientConfig";
import { UiMediaSoupPlaybackParamatersConfig } from "../../../generated/UiMediaSoupPlaybackParamatersConfig";
import { UiMediaSoupPublishingParametersConfig } from "../../../generated/UiMediaSoupPublishingParametersConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
export declare class UiMediaSoupV2WebRtcClient extends AbstractUiComponent<UiMediaSoupV2WebRtcClientConfig> implements UiMediaSoupV2WebRtcClientCommandHandler, UiMediaSoupV2WebRtcClientEventSource {
    readonly onPublishingSucceeded: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PublishingSucceededEvent>;
    readonly onPublishingFailed: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PublishingFailedEvent>;
    readonly onPublishedStreamEnded: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PublishedStreamEndedEvent>;
    readonly onPublishedStreamsStatusChanged: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PublishedStreamsStatusChangedEvent>;
    readonly onConnectionStateChanged: TeamAppsEvent<UiMediaSoupV2WebRtcClient_ConnectionStateChangedEvent>;
    readonly onPlaybackSucceeded: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PlaybackSucceededEvent>;
    readonly onPlaybackFailed: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PlaybackFailedEvent>;
    readonly onPlaybackProfileChanged: TeamAppsEvent<UiMediaSoupV2WebRtcClient_PlaybackProfileChangedEvent>;
    readonly onVoiceActivityChanged: TeamAppsEvent<UiMediaSoupV2WebRtcClient_VoiceActivityChangedEvent>;
    readonly onClicked: TeamAppsEvent<UiMediaSoupV2WebRtcClient_ClickedEvent>;
    private $main;
    private conference;
    private $image;
    private $videoContainer;
    private $video;
    private $profileDisplay;
    private $icons;
    private $caption;
    private multiStreamMixer;
    private $spinner;
    private currentSourceStreams;
    private connectionStatus;
    constructor(config: UiMediaSoupV2WebRtcClientConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    publish(parameters: UiMediaSoupPublishingParametersConfig): Promise<void>;
    private addVoiceActivityDetection;
    private retrieveUserMedia;
    private publishMediaStream;
    private getDisplayStream;
    private updateStateCssClass;
    playback(parameters: UiMediaSoupPlaybackParamatersConfig): void;
    stop(): void;
    update(config: UiMediaSoupV2WebRtcClientConfig): void;
    private updateVideoVisibility;
    setActive(active: boolean): void;
    private isVideoShown;
    onResize(): void;
    private static createVideoConstraints;
    private static createDisplayMediaStreamConstraints;
    static canPublishScreen(): boolean;
}
