import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiInfiniteItemView_ItemClickedEvent, UiInfiniteItemView_ContextMenuRequestedEvent, UiInfiniteItemViewCommandHandler, UiInfiniteItemViewConfig, UiInfiniteItemViewEventSource, UiInfiniteItemView_DisplayedRangeChangedEvent } from "../generated/UiInfiniteItemViewConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiItemJustification } from "../generated/UiItemJustification";
import { UiVerticalItemAlignment } from "../generated/UiVerticalItemAlignment";
import { UiComponent } from "./UiComponent";
export declare class UiInfiniteItemView extends AbstractUiComponent<UiInfiniteItemViewConfig> implements UiInfiniteItemViewCommandHandler, UiInfiniteItemViewEventSource {
    readonly onDisplayedRangeChanged: TeamAppsEvent<UiInfiniteItemView_DisplayedRangeChangedEvent>;
    readonly onItemClicked: TeamAppsEvent<UiInfiniteItemView_ItemClickedEvent>;
    readonly onContextMenuRequested: TeamAppsEvent<UiInfiniteItemView_ContextMenuRequestedEvent>;
    private $mainDomElement;
    private $grid;
    private grid;
    private dataProvider;
    private itemTemplateRenderer;
    private uuid;
    private horizontalItemMargin;
    private itemWidth;
    private itemJustification;
    private verticalItemAlignment;
    private contextMenu;
    constructor(config: UiInfiniteItemViewConfig, context: TeamAppsUiContext);
    private createGrid;
    private throttledFireDisplayedRangeChanged;
    private createDisplayRangeChangedEvent;
    private getCurrentlyDisplayedRecordIds;
    private calculateItemWidthInPixels;
    addData(startIndex: number, data: any[], totalNumberOfRecords: number, clearTableCache: boolean): void;
    private updateAutoHeight;
    removeData(ids: number[]): void;
    onResize(): void;
    doGetMainElement(): HTMLElement;
    private updateStyles;
    setHorizontalItemMargin(horizontalItemMargin: number): void;
    setVerticalItemAlignment(verticalItemAlignment: UiVerticalItemAlignment): void;
    setItemTemplate(itemTemplate: UiTemplateConfig): void;
    setItemWidth(itemWidth: number): void;
    setItemJustification(itemJustification: UiItemJustification): void;
    setContextMenuContent(requestId: number, component: UiComponent): void;
    closeContextMenu(requestId: number): void;
}
