import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiMapMarkerClusterConfig } from "../generated/UiMapMarkerClusterConfig";
import { UiHeatMapDataConfig } from "../generated/UiHeatMapDataConfig";
import { UiMap_LocationChangedEvent, UiMap_MapClickedEvent, UiMap_MarkerClickedEvent, UiMap_ShapeDrawnEvent, UiMap_ZoomLevelChangedEvent, UiMapCommandHandler, UiMapConfig, UiMapEventSource } from "../generated/UiMapConfig";
import { UiMapType } from "../generated/UiMapType";
import "leaflet.markercluster";
import "leaflet.heat";
import "leaflet-draw";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiMapMarkerClientRecordConfig } from "../generated/UiMapMarkerClientRecordConfig";
import { UiMapLocationConfig } from "../generated/UiMapLocationConfig";
import { UiMapShapeType } from "../generated/UiMapShapeType";
import { AbstractUiMapShapeConfig } from "../generated/AbstractUiMapShapeConfig";
import { UiShapePropertiesConfig } from "../generated/UiShapePropertiesConfig";
import { UiMapConfigConfig } from "../generated/UiMapConfigConfig";
export declare class UiMap extends AbstractUiComponent<UiMapConfig> implements UiMapCommandHandler, UiMapEventSource {
    readonly onZoomLevelChanged: TeamAppsEvent<UiMap_ZoomLevelChangedEvent>;
    readonly onLocationChanged: TeamAppsEvent<UiMap_LocationChangedEvent>;
    readonly onMapClicked: TeamAppsEvent<UiMap_MapClickedEvent>;
    readonly onMarkerClicked: TeamAppsEvent<UiMap_MarkerClickedEvent>;
    readonly onShapeDrawn: TeamAppsEvent<UiMap_ShapeDrawnEvent>;
    private id;
    private leaflet;
    private tileLayer;
    private clusterLayer;
    private heatMapLayer;
    private markerTemplateRenderers;
    private $map;
    private shapesById;
    private markersByClientId;
    private drawCircleFeature;
    private drawPolygonFeature;
    private drawPolylineFeature;
    private drawRectangleFeature;
    constructor(config: UiMapConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    private createLeafletMap;
    addShape(shapeId: string, shapeConfig: AbstractUiMapShapeConfig): void;
    removeShape(shapeId: string): void;
    updateShape(shapeId: string, shapeConfig: AbstractUiMapShapeConfig): void;
    addPolylinePoints(lineId: string, points: UiMapLocationConfig[]): void;
    private convertToLatLng;
    addMarker(markerConfig: UiMapMarkerClientRecordConfig): void;
    removeMarker(id: number): void;
    private createMarker;
    setZoomLevel(zoomLevel: number): void;
    setMapConfig(mapConfig: UiMapConfigConfig): void;
    setMapType(mapType: UiMapType): void;
    setLocation(location: UiMapLocationConfig): void;
    private createLeafletLatLng;
    setMapMarkerCluster(clusterConfig: UiMapMarkerClusterConfig): void;
    setHeatMap(data: UiHeatMapDataConfig): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    fitBounds(southWest: UiMapLocationConfig, northEast: UiMapLocationConfig): void;
    onResize(): void;
    startDrawingShape(shapeType: UiMapShapeType, shapeProperties: UiShapePropertiesConfig): void;
    stopDrawingShape(): void;
}
