import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiToolButton_ClickedEvent, UiToolButton_DropDownOpenedEvent, UiToolButtonCommandHandler, UiToolButtonConfig, UiToolButtonEventSource } from "../../generated/UiToolButtonConfig";
import { AbstractUiComponent } from "../AbstractUiComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComponent } from "../UiComponent";
export declare class UiToolButton extends AbstractUiComponent<UiToolButtonConfig> implements UiToolButtonEventSource, UiToolButtonCommandHandler {
    readonly onClicked: TeamAppsEvent<UiToolButton_ClickedEvent>;
    readonly onDropDownOpened: TeamAppsEvent<UiToolButton_DropDownOpenedEvent>;
    private $button;
    private _dropDown;
    private dropDownComponent;
    private minDropDownWidth;
    private minDropDownHeight;
    private openDropDownIfNotSet;
    constructor(config: UiToolButtonConfig, context: TeamAppsUiContext);
    private readonly dropDown;
    doGetMainElement(): HTMLElement;
    setDropDownSize(minDropDownWidth: number, minDropDownHeight: number): void;
    setDropDownComponent(component: UiComponent): void;
    private closeDropDown;
    setOpenDropDownIfNotSet(openDropDownIfNotSet: boolean): void;
    setGrayOutIfNotHovered(grayOutIfNotHovered: boolean): void;
    setIcon(icon: string): void;
    setPopoverText(popoverText: string): void;
}
