import { UiRelativeWorkSpaceViewPosition } from "../../generated/UiRelativeWorkSpaceViewPosition";
import { UiWorkSpaceLayoutViewConfig } from "../../generated/UiWorkSpaceLayoutViewConfig";
import { ViewInfo } from "./ViewInfo";
import { UiWorkSpaceLayout } from "./UiWorkSpaceLayout";
import { UiSplitSizePolicy } from "../../generated/UiSplitSizePolicy";
import { ViewContainer, ViewContainerListener } from "./ViewContainer";
import { UiEvent } from "../../generated/UiEvent";
import { UiWorkSpaceLayoutItemConfig } from "../../generated/UiWorkSpaceLayoutItemConfig";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { WindowLayoutDescriptor } from "./WindowLayoutDescriptor";
import { UiComponent } from "../UiComponent";
export interface ChildWindowViewContainerListener extends ViewContainerListener {
    handleInitialized(windowId: string, initialViewInfo: ViewInfo): void;
    handleUiEvent(uiEvent: UiEvent): void;
    handleClosed(childWindowViewContainer: ChildWindowViewContainer): void;
}
export declare class ChildWindowViewContainer implements ViewContainer {
    private childWindow;
    readonly windowId: string;
    private port;
    private initialViewInfo;
    private owner;
    private context;
    private newWindowBackgroundImage;
    private newWindowBlurredBackgroundImage;
    private listener;
    private static logger;
    private _viewInfos;
    private deferredExecutor;
    private methodInvocationResponseCallbacksByCorrelationId;
    constructor(childWindow: Window, windowId: string, port: MessagePort, initialViewInfo: ViewInfo, owner: UiWorkSpaceLayout, context: TeamAppsUiContext, newWindowBackgroundImage: string, newWindowBlurredBackgroundImage: string, listener: ChildWindowViewContainerListener);
    readonly viewNames: string[];
    getViewInfo(viewName: string): ViewInfo;
    private handlePortMessage;
    refreshViewComponent(viewName: string, component: UiComponent): void;
    refreshViewAttributes(viewName: string, tabIcon: string, tabCaption: string, tabCloseable: boolean, visible: boolean): void;
    addViewToTopLevel(newView: UiWorkSpaceLayoutViewConfig, windowId: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): void;
    addViewRelativeToOtherView(newView: UiWorkSpaceLayoutViewConfig, existingViewName: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): void;
    addViewAsTab(newView: UiWorkSpaceLayoutViewConfig, itemId: string): void;
    addViewAsNeighbourTab(newView: UiWorkSpaceLayoutViewConfig, existingViewName: string): void;
    removeView(viewName: string): void;
    setViewVisible(viewName: string, visible: boolean): void;
    redefineLayout(newLayout: UiWorkSpaceLayoutItemConfig, addedViewConfigs: UiWorkSpaceLayoutViewConfig[]): void;
    moveViewToTopLevel(viewName: string, windowId: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): void;
    moveViewRelativeToOtherView(viewName: string, existingViewName: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): void;
    moveViewToTab(viewName: string, existingViewName: string): void;
    selectViewTab(viewName: string): void;
    setViewGroupPanelState(viewGroupId: string): void;
    getLayoutDescriptor(): Promise<WindowLayoutDescriptor>;
    private sendCommandToWindow;
    private invokeMethod;
}
