import { UiItemViewItemGroupConfig } from "../generated/UiItemViewItemGroupConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { Renderer } from "./Common";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiItemView_ItemClickedEvent, UiItemViewCommandHandler, UiItemViewConfig, UiItemViewEventSource } from "../generated/UiItemViewConfig";
import { UiItemJustification } from "../generated/UiItemJustification";
import { UiIdentifiableClientRecordConfig } from "../generated/UiIdentifiableClientRecordConfig";
import { UiVerticalItemAlignment } from "../generated/UiVerticalItemAlignment";
export declare var itemCssStringsJustification: {
    [UiItemJustification.LEFT]: string;
    [UiItemJustification.RIGHT]: string;
    [UiItemJustification.CENTER]: string;
    [UiItemJustification.SPACE_AROUND]: string;
    [UiItemJustification.SPACE_BETWEEN]: string;
    [UiItemJustification.SPACE_EVENLY]: string;
};
export declare var itemCssStringsAlignItems: {
    [UiVerticalItemAlignment.TOP]: string;
    [UiVerticalItemAlignment.CENTER]: string;
    [UiVerticalItemAlignment.BOTTOM]: string;
    [UiVerticalItemAlignment.STRETCH]: string;
};
export declare class UiItemView extends AbstractUiComponent<UiItemViewConfig> implements UiItemViewCommandHandler, UiItemViewEventSource {
    readonly onItemClicked: TeamAppsEvent<UiItemView_ItemClickedEvent>;
    private $itemView;
    private groupHeaderTemplateRenderer;
    private groupsByGroupId;
    private filterString;
    constructor(config: UiItemViewConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    addItemGroup(itemGroupConfig: UiItemViewItemGroupConfig): ItemGroup;
    private createItemGroup;
    refreshItemGroup(itemGroupConfig: UiItemViewItemGroupConfig): void;
    removeItemGroup(groupId: string): void;
    addItem(groupId: string, item: UiIdentifiableClientRecordConfig): void;
    removeItem(groupId: string, itemId: number): void;
    setFilter(filter: string): void;
    private filter;
    destroy(): void;
}
declare class ItemGroup {
    private itemView;
    private context;
    private config;
    private $itemGroup;
    private items;
    private trivialTreeBox;
    private itemRenderer;
    private filterString;
    private static logger;
    readonly onItemClicked: TeamAppsEvent<UiIdentifiableClientRecordConfig>;
    constructor(itemView: UiItemView, context: TeamAppsUiContext, config: UiItemViewItemGroupConfig, groupHeaderTemplateRenderer: Renderer);
    setFilter(filterString: string): void;
    private filter;
    private filterItems;
    getMainDomElement(): HTMLElement;
    addItem(item: UiIdentifiableClientRecordConfig): void;
    removeItem(itemId: number): void;
    destroy(): void;
}
export {};
